/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.yarpc.encoding.Serializer;
import io.yarpc.util.BufferUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements Serializer<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);

    @Override
    public <T> ByteBuffer marshal(T value) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return ByteBuffer.wrap(mapper.writeValueAsBytes(value));
    }

    @Override
    public <T> T unmarshal(ByteBuffer value, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(BufferUtil.toBytes(value), clazz);
    }
}

