/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.json;

import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.config.Config;
import io.yarpc.encoding.json.JsonClient;
import io.yarpc.encoding.json.JsonInboundHandler;
import io.yarpc.encoding.json.TestQuery;
import io.yarpc.encoding.json.TestResult;
import io.yarpc.handler.Handler;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.http.HTTPInbound;
import io.yarpc.transport.http.HTTPOutbound;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JsonIntegrationTest {
    private static final String respString = "apple";
    private static final int httpPort = 9090;
    private static final String ip = "127.0.0.1";
    private static RPC rpc;

    @BeforeClass
    public static void setupServer() throws IOException {
        final Inbound httpInbound = JsonIntegrationTest.setupHttpServer();
        final Outbound httpOutbound = JsonIntegrationTest.setupHttpClient();
        rpc = new RPC(new Config("testServer", (List<Inbound>)new ArrayList<Inbound>(){
            {
                this.add(httpInbound);
            }
        }, (Map<String, Outbound>)new HashMap<String, Outbound>(){
            {
                this.put("testHttpServer", httpOutbound);
            }
        }));
        JsonIntegrationTest.registerEndpoint();
        rpc.start();
    }

    private static Outbound setupHttpClient() throws IOException {
        return new HTTPOutbound(ip, 9090);
    }

    private static void registerEndpoint() {
        JsonIntegrationTest.registerHttpEndpoint();
    }

    private static void registerHttpEndpoint() {
        JsonInboundHandler jsonInboundHandler = new JsonInboundHandler(new Handler<TestQuery, TestResult>(){

            @Override
            public Response<TestResult> handle(Request<TestQuery> request) {
                return Response.Builder.forBody(new TestResult(request.getBody().getC())).build();
            }
        });
        rpc.register("testHttpEndpoint", jsonInboundHandler);
    }

    public static Inbound setupHttpServer() {
        return new HTTPInbound(9090);
    }

    @AfterClass
    public static void shutdownHttpServer() {
        rpc.stop();
    }

    @Test
    public void httpTest() throws Exception {
        JsonClient client = new JsonClient(rpc);
        Request<TestQuery> request = new Request.Builder<TestQuery>().body(new TestQuery(respString)).service("testHttpServer").procedure("testHttpEndpoint").caller("testClient").timeout(Duration.millis((long)1000L)).build();
        RPCFuture<Response<TestResult>> future = client.call(request, TestResult.class);
        Response response = (Response)future.get();
        Assert.assertEquals((Object)((TestResult)response.getBody()).getA(), (Object)respString);
    }
}

