/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.json;

import io.yarpc.RPC;
import io.yarpc.RPCClient;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Serializer;
import io.yarpc.encoding.json.JsonSerializer;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.ResponseListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonClient
extends RPCClient<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JsonClient.class);
    private static final Serializer<Object> serializer = new JsonSerializer();
    private final RPC rpc;

    public JsonClient(RPC rpc) {
        this.rpc = rpc;
    }

    @Override
    public <I, O> RPCFuture<Response<O>> call(Request<I> request, Class<O> responseBodyType) throws Exception {
        Outbound outbound = this.rpc.lookUpOutbound(request.getService());
        request.setEncoding("json");
        logger.debug(String.format("sending request %s", request.toString()));
        Request<ByteBuffer> transportRequest = Request.toByteBufferRequest(request, serializer);
        RPCFuture<Response<O>> rpcFuture = new RPCFuture<Response<O>>();
        outbound.send(transportRequest, new JsonResponseListener(responseBodyType, rpcFuture));
        return rpcFuture;
    }

    private static class JsonResponseListener<O>
    implements ResponseListener {
        private final Class<O> responseBodyType;
        private final RPCFuture<Response<O>> rpcFuture;

        private JsonResponseListener(Class<O> responseBodyType, RPCFuture<Response<O>> rpcFuture) {
            this.responseBodyType = responseBodyType;
            this.rpcFuture = rpcFuture;
        }

        @Override
        public void onResponseReceived(Response<ByteBuffer> transportResponse) {
            try {
                Response response = Response.fromByteBufferResponse(transportResponse, serializer, this.responseBodyType);
                this.rpcFuture.set(response);
            }
            catch (Exception e) {
                this.rpcFuture.setException(e);
            }
        }

        @Override
        public void onErrorReceived(Response<ByteBuffer> transportResponse) {
            this.rpcFuture.setException(transportResponse.getException());
        }
    }
}

