/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.crossdock.echo;

import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.config.Config;
import io.yarpc.crossdock.echo.Echo;
import io.yarpc.encoding.json.JsonClient;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.http.HTTPOutbound;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Duration;

public class EchoClient {
    private static final String caller = "echoClient";
    private static final String service = "yarpc-test";
    private static final String procedure = "echo";
    private final RPC rpc;
    private final JsonClient client;

    public EchoClient(final String ip, final int port) {
        this.rpc = new RPC(new Config(caller, (Map<String, Outbound>)new HashMap<String, Outbound>(){
            {
                try {
                    this.put(EchoClient.service, new HTTPOutbound(ip, port));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.client = new JsonClient(this.rpc);
    }

    public RPCFuture<Response<Echo>> call(String server, Echo body) throws Exception {
        Request<Echo> request = new Request.Builder<Echo>().body(body).service(service).procedure(procedure).caller(caller).timeout(Duration.millis((long)1000L)).build();
        return this.client.call(request, Echo.class);
    }
}

