/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.crossdock;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.config.Config;
import io.yarpc.crossdock.HarnessServerInboundHandler;
import io.yarpc.crossdock.echo.EchoInboundHandler;
import io.yarpc.encoding.json.JsonInboundHandler;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.http.HTTPInbound;
import java.util.ArrayList;
import java.util.List;

public class TestHarness {
    private static final int harnessPort = 8080;
    private static final int remotePort = 8081;
    private RPC rpc;
    private RPCFuture<Void> rpcFuture;

    public static void main(String[] args) throws Exception {
        TestHarness testHarness = new TestHarness();
        testHarness.startRPCServer();
        testHarness.start();
    }

    public void startRPCServer() {
        this.rpc = new RPC(new Config("testServer", (List<Inbound>)new ArrayList<Inbound>(){
            {
                this.add(new HTTPInbound(8081));
            }
        }));
        this.rpc.register("echo", new JsonInboundHandler(new EchoInboundHandler()));
        this.rpcFuture = this.rpc.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
                    ch.pipeline().addLast("aggegator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                    ch.pipeline().addLast("harness", (ChannelHandler)new HarnessServerInboundHandler());
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind("0.0.0.0", 8080).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

