/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.crossdock;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.yarpc.RPCFuture;
import io.yarpc.Response;
import io.yarpc.crossdock.echo.Echo;
import io.yarpc.crossdock.echo.EchoClient;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarnessServerInboundHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HarnessServerInboundHandler.class);
    private static final int remotePort = 8081;

    protected void messageReceived(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) throws Exception {
        String hash;
        EchoClient echoClient;
        RPCFuture<Response<Echo>> future;
        Response response;
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(fullHttpRequest.uri());
        List behaviors = (List)queryStringDecoder.parameters().get("behavior");
        List servers = (List)queryStringDecoder.parameters().get("server");
        if (behaviors == null || servers == null || behaviors.size() != 1 || servers.size() != 1) {
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            channelHandlerContext.writeAndFlush((Object)httpResponse);
            return;
        }
        String behavior = (String)behaviors.get(0);
        String server = (String)servers.get(0);
        logger.debug("behavior " + behavior + " " + server);
        String respBody = "not ok";
        if (behavior.equals("echo") && ((Echo)(response = (Response)(future = (echoClient = new EchoClient(server, 8081)).call(server, new Echo(hash = UUID.randomUUID().toString().substring(0, 7)))).get()).getBody()).getToken().equals(hash)) {
            respBody = "ok - Server said: " + hash;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])respBody.getBytes()));
        channelHandlerContext.writeAndFlush((Object)httpResponse);
        channelHandlerContext.pipeline().channel().close();
        channelHandlerContext.close();
    }
}

