/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc;

import io.yarpc.context.Context;
import io.yarpc.encoding.Serializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class Response<T> {
    private Map<String, String> headers;
    private T body;
    private Context context;
    private Exception exception;

    private Response(Builder<T> builder) {
        this.headers = ((Builder)builder).nestedHeaders;
        this.context = ((Builder)builder).nestedContext;
        this.body = ((Builder)builder).nestedRespBody;
        this.exception = builder.nestedException;
    }

    public static Response<ByteBuffer> toByteBufferResponse(Response response, Serializer serializer) throws Exception {
        return Builder.forBody(serializer.marshal(response.getBody())).headers(response.getHeaders()).context(response.getContext()).exception(response.getException()).build();
    }

    public static Response fromByteBufferResponse(Response<ByteBuffer> response, Serializer serializer, Class<?> respBodyType) throws Exception {
        return Builder.forBody(serializer.unmarshal(response.getBody(), respBodyType)).headers(response.getHeaders()).context(response.getContext()).exception(response.getException()).build();
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Class<T> getGenericType() {
        return this.body.getClass();
    }

    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public static class Builder<T> {
        public Exception nestedException;
        private T nestedRespBody;
        private Map<String, String> nestedHeaders;
        private Context nestedContext;

        public static <T> Builder<T> forBody(T body) {
            Builder<T> builder = new Builder<T>();
            return builder.body(body);
        }

        public Builder<T> body(T body) {
            this.nestedRespBody = body;
            return this;
        }

        public Builder<T> exception(Exception e) {
            this.nestedException = e;
            return this;
        }

        public Builder<T> headers(Map<String, String> headers) {
            this.nestedHeaders = headers;
            return this;
        }

        public Builder<T> context(Context context) {
            this.nestedContext = context;
            return this;
        }

        public Response<T> build() {
            return new Response(this);
        }
    }
}

