/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc;

import io.yarpc.context.Context;
import io.yarpc.encoding.Serializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.Duration;

public class Request<T> {
    private Context context;
    private Map<String, String> headers;
    private String encoding;
    private String service;
    private String procedure;
    private Duration timeout;
    private String caller;
    private T body;

    private Request(Builder<T> builder) {
        this.body = ((Builder)builder).nestedRespBody;
        this.headers = ((Builder)builder).nestedHeaders;
        this.procedure = ((Builder)builder).nestedProcedure;
        this.service = ((Builder)builder).nestedService;
        this.context = ((Builder)builder).nestedContext;
        this.timeout = ((Builder)builder).nestedTimeout;
        this.encoding = ((Builder)builder).nestedEncoding;
        if (this.timeout == null) {
            this.timeout = Duration.millis((long)1000L);
        }
        this.caller = ((Builder)builder).nestedCaller;
    }

    public static Request<ByteBuffer> toByteBufferRequest(Request request, Serializer serializer) throws Exception {
        return Builder.forBody(serializer.marshal(request.getBody())).caller(request.getCaller()).context(request.getContext()).encoding(request.getEncoding()).timeout(request.getTimeout()).procedure(request.getProcedure()).headers(request.getHeaders()).service(request.getService()).build();
    }

    public static Request fromByteBufferRequest(Request<ByteBuffer> request, Serializer serializer, Class<?> bodyType) throws Exception {
        return Builder.forBody(serializer.unmarshal(request.getBody(), bodyType)).caller(request.getCaller()).context(request.getContext()).encoding(request.getEncoding()).timeout(request.getTimeout()).procedure(request.getProcedure()).headers(request.getHeaders()).service(request.getService()).build();
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Class<T> getGenericType() {
        return this.body.getClass();
    }

    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public static class Builder<T> {
        private T nestedRespBody;
        private Map<String, String> nestedHeaders;
        private String nestedProcedure;
        private String nestedService;
        private Context nestedContext;
        private Duration nestedTimeout;
        private String nestedCaller;
        private String nestedEncoding;

        public static <T> Builder<T> forBody(T body) {
            Builder<T> builder = new Builder<T>();
            return builder.body(body);
        }

        public Builder<T> body(T body) {
            this.nestedRespBody = body;
            return this;
        }

        public Request<T> build() {
            return new Request(this);
        }

        public Builder<T> timeout(Duration timeout) {
            this.nestedTimeout = timeout;
            return this;
        }

        public Builder<T> encoding(String encoding) {
            this.nestedEncoding = encoding;
            return this;
        }

        public Builder<T> caller(String caller) {
            this.nestedCaller = caller;
            return this;
        }

        public Builder<T> headers(Map<String, String> headers) {
            this.nestedHeaders = headers;
            return this;
        }

        public Builder<T> service(String service) {
            this.nestedService = service;
            return this;
        }

        public Builder<T> procedure(String procedure) {
            this.nestedProcedure = procedure;
            return this;
        }

        public Builder<T> context(Context context) {
            this.nestedContext = context;
            return this;
        }
    }
}

