/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc;

import io.yarpc.HandlerRegistry;
import io.yarpc.MapHandlerRegistry;
import io.yarpc.RPCFuture;
import io.yarpc.config.Config;
import io.yarpc.exception.OutboundNotFoundException;
import io.yarpc.handler.HandlerWrapper;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.Outbound;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPC {
    private static final Logger logger = LoggerFactory.getLogger(RPC.class);
    private Config config;
    private HandlerRegistry mHandlerRegistry = new MapHandlerRegistry();
    private RPCFuture runningFuture;

    public RPC(Config config) {
        this.config = config;
    }

    public void register(String proceduer, HandlerWrapper handler) {
        this.mHandlerRegistry.addHandler(proceduer, handler);
    }

    public RPCFuture<Void> start() {
        this.runningFuture = new RPCFuture();
        List<Inbound> inbounds = this.config.getInbounds();
        for (Inbound inbound : inbounds) {
            try {
                inbound.setHandlerRegistry(this.mHandlerRegistry);
                inbound.start();
            }
            catch (Exception e) {
                this.runningFuture.setException(e);
            }
        }
        return this.runningFuture;
    }

    public Outbound lookUpOutbound(String service) throws OutboundNotFoundException {
        Outbound outbound = this.config.getOutbounds().get(service);
        if (outbound == null) {
            throw new OutboundNotFoundException(String.format("Cannot find outbound by service name: %s", service));
        }
        return outbound;
    }

    public void stop() {
        if (this.runningFuture == null || this.runningFuture.isCancelled() || this.runningFuture.isDone()) {
            return;
        }
        List<Inbound> inbounds = this.config.getInbounds();
        for (Inbound inbound : inbounds) {
            try {
                inbound.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.runningFuture.set(null);
    }
}

