/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.transport.tchannel;

import com.uber.tchannel.api.TChannel;
import io.yarpc.HandlerRegistry;
import io.yarpc.transport.Inbound;

import java.util.concurrent.Future;

/**
 * TChannel Inbound supports TChannel protocol.
 */
public class TChannelInbound extends Inbound {
    private final TChannel tchannel;
    private HandlerRegistry handlerRegistry;

    public TChannelInbound(TChannel tchannel) {
        this.tchannel = tchannel;
    }

    public void setHandlerRegistry(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
        this.tchannel.setDefaultUserHandler(new TChannelInboundHandler(this.handlerRegistry));
    }

    @Override
    public void stop() {
        tchannel.shutdown(false);
    }

    @Override
    public Future start() throws Exception {
        return tchannel.listen().channel().closeFuture();
    }
}
