/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.encoding.thrift;

import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Encoding;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import io.yarpc.thrift.generated.KeyValue.getValue_args;
import io.yarpc.thrift.generated.KeyValue.getValue_result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThriftInboundHandlerTest {

    private ThriftInboundHandler thriftInboundHandler;

    @Before
    public void setup() {
        this.thriftInboundHandler = new ThriftInboundHandler(new Handler<getValue_args,
                getValue_result>() {

            @Override
            public Response<getValue_result> handle(
                    Request<getValue_args> request) throws RPCException {
                return Response.Builder.forBody(new getValue_result("test", null)).build();
            }
        });
    }

    @Test
    public void testParseThriftHandler() {

        Assert.assertEquals(this.thriftInboundHandler.getResponseBodyType(), getValue_result.class);
        Assert.assertEquals(this.thriftInboundHandler.getReqestBodyType(), getValue_args.class);
    }

    @Test
    public void testEncoding() {
        Assert.assertEquals(this.thriftInboundHandler.getEncoding(), Encoding.THRIFT);
    }
}
