/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.encoding.raw;

import io.yarpc.util.BufferUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class RawSerializerTest {
    private static final String testString = "test String";
    private RawSerializer rawSerializer;

    @Before
    public void setup() {
        this.rawSerializer = new RawSerializer();
    }

    @Test
    public void testMarshal() {
        Assert.assertTrue(Arrays.equals(
                BufferUtil.toBytes(this.rawSerializer.marshal(ByteBuffer.wrap(testString.getBytes()))),
                testString.getBytes())
        );
    }

    @Test
    public void testUnmarshal() {
        Assert.assertEquals(this.rawSerializer.unmarshal(ByteBuffer.wrap(testString.getBytes()), ByteBuffer.class),
                ByteBuffer.wrap(testString.getBytes())
        );
    }
}
