/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.encoding.raw;

import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Encoding;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.nio.ByteBuffer;

public class RawInboundHandlerTest {

    private RawInboundHandler rawInboundHandler;

    @Before
    public void setup() {
        this.rawInboundHandler = new RawInboundHandler(new Handler<ByteBuffer, ByteBuffer>() {

            @Override
            public Response<ByteBuffer> handle(Request<ByteBuffer> request) throws RPCException {
                return Response.Builder.forBody(ByteBuffer.wrap("test".getBytes())).build();
            }
        });
    }

    @Test
    public void testParseThriftHandler() {
        Assert.assertEquals(this.rawInboundHandler.getResponseBodyType(), ByteBuffer.class);
        Assert.assertEquals(this.rawInboundHandler.getReqestBodyType(), ByteBuffer.class);
    }

    @Test
    public void testEncoding() {
        Assert.assertEquals(this.rawInboundHandler.getEncoding(), Encoding.RAW);
    }
}
