/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.encoding.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.yarpc.util.BufferUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class JsonSerializerTest {
    private static final String testString = "test string";
    private JsonSerializer jsonSerializer;

    @Before
    public void setup() {
        this.jsonSerializer = new JsonSerializer();
    }

    @Test
    public void testMarshal() throws JsonProcessingException {
        Assert.assertTrue(Arrays.equals(
                BufferUtil.toBytes(this.jsonSerializer.marshal(new TestQuery(testString)))
                , new byte[]{
                        123, // "{"
                        34, 99, 34, // " c "
                        58, 34, // ": "
                        116, 101, 115, 116, 32, 115, 116, 114, 105, 110, 103, // "test string"
                        34, 125 // "}"
                }
        ));
    }

    @Test
    public void testUnmarshal() throws IOException {
        Assert.assertEquals(this.jsonSerializer.unmarshal(
                ByteBuffer.wrap(new byte[]{
                        123, // "{"
                        34, 99, 34, // " c "
                        58, 34, // ": "
                        116, 101, 115, 116, 32, 115, 116, 114, 105, 110, 103, // "test string"
                        34, 125 // "}"
                }),
                TestQuery.class
        ).getC(), testString);
    }
}
