/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.crossdock.echo;

import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.config.Config;
import io.yarpc.encoding.json.JsonClient;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.http.HTTPOutbound;
import org.joda.time.Duration;

import java.io.IOException;
import java.util.HashMap;

public class EchoClient {
    private static final String caller = "echoClient";
    private static final String service = "yarpc-test";
    private static final String procedure = "echo";
    private final RPC rpc;
    private final JsonClient client;

    public EchoClient(final String ip, final int port) {
        this.rpc = new RPC(new Config(
                caller,
                new HashMap<String, Outbound>() {{
                    try {
                        this.put(service, new HTTPOutbound(ip, port));
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }}));
        this.client = new JsonClient(this.rpc);
    }

    public RPCFuture<Response<Echo>> call(String server, Echo body) throws Exception {
        Request<Echo> request = new Request.Builder<Echo>()
                .body(body)
                .service(service)
                .procedure(procedure)
                .caller(caller)
                .timeout(Duration.millis(1000))
                .build();
        return this.client.call(request, Echo.class);
    }

}
