/**
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.yarpc.config;


import io.yarpc.transport.Inbound;
import io.yarpc.transport.Outbound;

import java.util.List;
import java.util.Map;

public class Config {
    private int port;
    private String service;
    private List<Inbound> inbounds;
    private Map<String, Outbound> outbounds;

    public Config(String service) {
        this(service, null, null);
    }

    public Config(String service, List<Inbound> inbounds) {
        this(service, inbounds, null);
    }

    public Config(String service, Map<String, Outbound> outbounds) {
        this(service, null, outbounds);
    }

    public Config(String service, List<Inbound> inbounds, Map<String, Outbound> outbounds) {
        this.service = service;
        this.inbounds = inbounds;
        this.outbounds = outbounds;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public List<Inbound> getInbounds() {
        return inbounds;
    }

    public void setInbounds(List<Inbound> inbounds) {
        this.inbounds = inbounds;
    }

    public Map<String, Outbound> getOutbounds() {
        return outbounds;
    }

    public void setOutbounds(Map<String, Outbound> outbounds) {
        this.outbounds = outbounds;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}
