/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.sqli.repository.dialect;

import io.xream.sqli.dialect.Dialect;
import io.xream.x7.base.util.StringUtil;
import org.springframework.core.env.Environment;

public interface DialectAdapter {
    public static final String MYSQL = "mysql";
    public static final String IMPALA = "impala";
    public static final String CLICKHOUSE = "clickhouse";
    public static final String POSTGRESQL = "postgresql";
    public static final String ORACLE = "oracle";
    public static final String TAOS = "taosdata";

    default public Dialect adapter(String driverClassName) {
        try {
            Dialect dialect = null;
            dialect = driverClassName.contains(POSTGRESQL) ? (Dialect)Class.forName("io.xream.sqli.dialect.MySqlDialect").newInstance() : (driverClassName.contains(IMPALA) ? (Dialect)Class.forName("io.xream.sqli.dialect.ImpalaDialect").newInstance() : (driverClassName.contains(CLICKHOUSE) ? (Dialect)Class.forName("io.xream.sqli.dialect.ClickhouseDialect").newInstance() : (driverClassName.contains(ORACLE) ? (Dialect)Class.forName("io.xream.sqli.dialect.OracleDialect").newInstance() : (driverClassName.contains(TAOS) ? (Dialect)Class.forName("io.xream.sqli.dialect.TAOSDialect").newInstance() : (Dialect)Class.forName("io.xream.sqli.dialect.MySqlDialect").newInstance()))));
            return dialect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    default public String getDbDriverKey(Environment environment) {
        String driverClassName = null;
        try {
            driverClassName = environment.getProperty("spring.datasource.driver-class-name");
            if (StringUtil.isNullOrEmpty((String)driverClassName)) {
                driverClassName = environment.getProperty("spring.datasource.driverClassName");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (driverClassName == null) {
            return MYSQL;
        }
        return driverClassName.toLowerCase();
    }
}

