/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import x7.core.bean.BeanElement;
import x7.core.bean.DataPermission;
import x7.core.bean.Parsed;
import x7.core.config.ConfigAdapter;
import x7.core.util.BeanUtil;
import x7.core.util.JsonX;

public class SqlParserUtil {
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String SQL_KEYWORD_MARK = "`";

    public static Map<String, Object> getRefreshMap(Parsed parsed, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(obj)) {
            return map;
        }
        Class<?> clz = obj.getClass();
        if (obj instanceof DataPermission) {
            DataPermission dp = (DataPermission)obj;
            dp.setDataPermissionValue(null);
        }
        try {
            for (BeanElement element : parsed.getBeanElementList()) {
                Method method = element.getMethod;
                Object value = method.invoke(obj, new Object[0]);
                Class<?> type = method.getReturnType();
                String property = element.getProperty();
                if (type == Integer.TYPE) {
                    if ((Integer)value == 0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Integer.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Long.TYPE) {
                    if ((Long)value == 0L) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Long.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Double.TYPE) {
                    if ((Double)value == 0.0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Double.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Float.TYPE) {
                    if (((Float)value).floatValue() == 0.0f) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Float.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    if (!((Boolean)value).booleanValue()) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == String.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type.isEnum()) {
                    if (value == null) continue;
                    map.put(property, ((Enum)value).name());
                    continue;
                }
                if (type == java.util.Date.class || clz == Date.class || type == Timestamp.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == BigDecimal.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (!element.isJson || value == null) continue;
                String str = JsonX.toJson((Object)value);
                map.put(property, str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> getQueryMap(Parsed parsed, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clz = obj.getClass();
        try {
            for (BeanElement element : parsed.getBeanElementList()) {
                Method method = element.getMethod;
                Object value = method.invoke(obj, new Object[0]);
                Class<?> type = method.getReturnType();
                String property = element.getProperty();
                if (type == Long.TYPE) {
                    if ((Long)value == 0L) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Long.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == String.class) {
                    if (value == null || value.equals("")) continue;
                    map.put(property, value);
                    continue;
                }
                if (type.isEnum()) {
                    if (value == null) continue;
                    map.put(property, ((Enum)value).name());
                    continue;
                }
                if (type == Integer.TYPE) {
                    if ((Integer)value == 0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Integer.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Double.TYPE) {
                    if ((Double)value == 0.0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Double.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Float.TYPE) {
                    if (((Float)value).floatValue() == 0.0f) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Float.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    if (!((Boolean)value).booleanValue()) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == BigDecimal.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == java.util.Date.class || clz == Date.class || type == Timestamp.class) {
                    if (value == null) continue;
                    map.put(property, value);
                    continue;
                }
                if (value == null) continue;
                map.put(property, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println("_queryMap: " + map);
        }
        return map;
    }

    public static String mapperForManu(String sql, Parsed parsed) {
        String value;
        String key;
        if (parsed.isNoSpec()) {
            return sql;
        }
        if (!sql.contains(COMMA)) {
            return sql;
        }
        for (String property : parsed.getPropertyMapperMap().keySet()) {
            key = SPACE + property + COMMA;
            value = SPACE + parsed.getMapper(property) + COMMA;
            sql = sql.replaceAll(key, value);
        }
        for (String property : parsed.getPropertyMapperMap().keySet()) {
            key = COMMA + property + COMMA;
            value = COMMA + parsed.getMapper(property) + COMMA;
            sql = sql.replaceAll(key, value);
        }
        return sql;
    }

    public static String mapper(String sql, Parsed parsed) {
        if (parsed.isNoSpec()) {
            return sql;
        }
        sql = SqlParserUtil.mapperName(sql, parsed);
        boolean flag = sql.contains(SQL_KEYWORD_MARK);
        for (String property : parsed.getPropertyMapperMap().keySet()) {
            String value;
            String key;
            if (flag && sql.contains(key = SQL_KEYWORD_MARK + property + SQL_KEYWORD_MARK)) {
                value = parsed.getMapper(property);
                if (!value.startsWith(SQL_KEYWORD_MARK)) {
                    value = SQL_KEYWORD_MARK + parsed.getMapper(property) + SQL_KEYWORD_MARK;
                }
                sql = sql.replace(key, value);
                continue;
            }
            key = SPACE + property + SPACE;
            value = SPACE + parsed.getMapper(property) + SPACE;
            if (!sql.startsWith(SPACE)) {
                sql = SPACE + sql;
            }
            sql = sql.replaceAll(key, value);
        }
        return sql;
    }

    public static String mapperName(String sql, Parsed parsed) {
        String clzName = parsed.getClzName();
        clzName = BeanUtil.getByFirstLower((String)clzName);
        String tableName = parsed.getTableName();
        return SqlParserUtil.mapperName(sql, clzName, tableName);
    }

    public static String mapperName(String sql, String clzName, String tableName) {
        if (sql.endsWith(clzName)) {
            sql = sql + SPACE;
        }
        if ((sql = sql.replace(SPACE + clzName + SPACE, SPACE + tableName + SPACE)).contains(SQL_KEYWORD_MARK)) {
            sql = sql.replace(SQL_KEYWORD_MARK + clzName + SQL_KEYWORD_MARK, SQL_KEYWORD_MARK + tableName + SQL_KEYWORD_MARK);
        }
        return sql;
    }
}

