/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.async.CasualWorker;
import x7.core.bean.Criteria;
import x7.core.bean.DomainObject;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.condition.InCondition;
import x7.core.bean.condition.RefreshCondition;
import x7.core.util.ExceptionUtil;
import x7.core.util.StringUtil;
import x7.core.web.Page;
import x7.repository.BaseRepository;
import x7.repository.EntityHolder;
import x7.repository.HealthChecker;
import x7.repository.IdGenerator;
import x7.repository.KeyOne;
import x7.repository.ManuRepository;
import x7.repository.Repository;
import x7.repository.exception.PersistenceException;
import x7.repository.internal.DomainObjectRepositoy;

public abstract class DefaultRepository<T>
implements BaseRepository<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseRepository.class);
    private Class<T> clz;
    private Repository.IdGenerator idGenerator;
    private Repository repository;
    private DomainObjectRepositoy domainObjectRepositoy;

    @Override
    public Class<T> getClz() {
        return this.clz;
    }

    public void setClz(Class<T> clz) {
        this.clz = clz;
    }

    public void setIdGenerator(Repository.IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setDomainObjectRepositoy(DomainObjectRepositoy domainObjectRepositoy) {
        this.domainObjectRepositoy = domainObjectRepositoy;
    }

    public DefaultRepository() {
        this.parse();
    }

    private void parse() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (!(params[0] instanceof Class)) {
            return;
        }
        this.clz = (Class)params[0];
        this.hook();
    }

    protected void hook() {
        if (!EntityHolder.listAll().contains(this.clz)) {
            EntityHolder.listAll().add(this.clz);
        }
        if (!HealthChecker.getRepositoryList().contains(this)) {
            HealthChecker.getRepositoryList().add(this);
        }
    }

    @Override
    public long createId() {
        String clzName = this.clz.getName();
        long id = this.idGenerator.createId(clzName);
        if (id == 0L) {
            throw new PersistenceException("UNEXPECTED EXCEPTION WHILE CREATING ID");
        }
        CasualWorker.accept(() -> {
            IdGenerator generator = new IdGenerator();
            generator.setClzName(clzName);
            generator.setMaxId(id);
            StringBuilder sb = new StringBuilder();
            sb.append("update idGenerator set maxId = ").append(id).append(" where clzName = '").append(clzName).append("' and ").append(id).append(" > maxId ;");
            try {
                ManuRepository.execute(generator, sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return id;
    }

    @Override
    public boolean createBatch(List<T> objList) {
        return this.repository.createBatch(objList);
    }

    @Override
    public long create(T obj) {
        logger.info("BaesRepository.create: " + obj);
        long id = this.repository.create(obj);
        return id;
    }

    @Override
    public boolean refresh(RefreshCondition refreshCondition) {
        refreshCondition.setClz(this.clz);
        Parsed parsed = Parser.get(this.clz);
        Field keyField = parsed.getKeyField(1);
        if (Objects.isNull(keyField)) {
            throw new PersistenceException("No PrimaryKey, UnSafe Refresh, try to invoke DefaultRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
        }
        Criteria criteriaCondition = refreshCondition.getCondition();
        boolean unSafe = true;
        if (unSafe) {
            String key = parsed.getKey(1);
            for (Criteria.X x : criteriaCondition.getListX()) {
                Object value;
                if (!key.equals(x.getKey()) || !Objects.nonNull(value = x.getValue()) || value.toString().equals("0")) continue;
                unSafe = false;
            }
        }
        if (unSafe) {
            throw new PersistenceException("UnSafe Refresh, try to invoke DefaultRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
        }
        return this.repository.refresh(refreshCondition);
    }

    @Override
    public boolean refreshUnSafe(RefreshCondition<T> refreshCondition) {
        refreshCondition.setClz(this.clz);
        return this.repository.refresh(refreshCondition);
    }

    @Override
    public boolean remove(final String keyOne) {
        if (StringUtil.isNullOrEmpty((String)keyOne)) {
            return false;
        }
        return this.repository.remove(new KeyOne<T>(){

            @Override
            public Object get() {
                return keyOne;
            }

            @Override
            public Class<T> getClzz() {
                return DefaultRepository.this.clz;
            }
        });
    }

    @Override
    public boolean remove(final long keyOne) {
        if (keyOne == 0L) {
            return false;
        }
        return this.repository.remove(new KeyOne<T>(){

            @Override
            public Object get() {
                return keyOne;
            }

            @Override
            public Class<T> getClzz() {
                return DefaultRepository.this.clz;
            }
        });
    }

    @Override
    public T get(long idOne) {
        if (idOne == 0L) {
            return null;
        }
        Parsed parsed = Parser.get(this.clz);
        Field f = parsed.getKeyField(1);
        Object condition = null;
        try {
            condition = this.clz.newInstance();
            f.set(condition, idOne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.repository.getOne(condition);
    }

    @Override
    public T get(String idOne) {
        if (StringUtil.isNullOrEmpty((String)idOne)) {
            return null;
        }
        Parsed parsed = Parser.get(this.clz);
        Field f = parsed.getKeyField(1);
        Object condition = null;
        try {
            condition = this.clz.newInstance();
            f.set(condition, idOne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.repository.getOne(condition);
    }

    @Override
    public List<T> list() {
        Object t = null;
        try {
            t = this.clz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
        }
        return this.repository.list((Object)t);
    }

    @Override
    public List<T> list(T conditionObj) {
        if (conditionObj instanceof Criteria.ResultMappedCriteria) {
            throw new RuntimeException("Exception supported, no page not to invoke repository.list(criteriaJoinalbe);");
        }
        return this.repository.list(conditionObj);
    }

    @Override
    public T getOne(T conditionObj) {
        if (conditionObj == null) {
            return null;
        }
        return this.repository.getOne(conditionObj);
    }

    @Override
    public void refreshCache() {
        this.repository.refreshCache(this.clz);
    }

    @Override
    public List<T> in(InCondition inCondition) {
        inCondition.setClz(this.clz);
        return this.repository.in(inCondition);
    }

    @Override
    public Page<T> find(Criteria criteria) {
        if (criteria instanceof Criteria.ResultMappedCriteria) {
            throw new RuntimeException("Codeing Exception: maybe {Criteria.ResultMappedCriteria criteria = builder.get();} instead of {Criteria criteria = builder.get();}");
        }
        return this.repository.find(criteria);
    }

    @Override
    public Page<Map<String, Object>> find(Criteria.ResultMappedCriteria criteria) {
        criteria.setClz(this.clz);
        return this.repository.find(criteria);
    }

    @Override
    public List<Map<String, Object>> list(Criteria.ResultMappedCriteria resultMapped) {
        resultMapped.setClz(this.clz);
        return this.repository.list(resultMapped);
    }

    @Override
    public List<T> list(Criteria criteria) {
        if (criteria instanceof Criteria.ResultMappedCriteria) {
            throw new RuntimeException("Codeing Exception: maybe {Criteria.ResultMappedCriteria criteria = builder.get();} instead of {Criteria criteria = builder.get();}");
        }
        return this.repository.list(criteria);
    }

    @Override
    public <WITH> List<DomainObject<T, WITH>> listDomainObject(Criteria.DomainObjectCriteria domainObjectCriteria) {
        if (StringUtil.isNullOrEmpty((String)domainObjectCriteria.getMainPropperty())) {
            throw new RuntimeException("DefaultRepository.listDomainObject(domainObjectCriteria), domainObjectCriteria.getMainPropperty()is null");
        }
        if (domainObjectCriteria.getRelativeClz() == null) {
            if (domainObjectCriteria.getKnownMainIdList() == null || domainObjectCriteria.getKnownMainIdList().isEmpty()) {
                return this.domainObjectRepositoy.listDomainObject_NonRelative(domainObjectCriteria);
            }
            return this.domainObjectRepositoy.listDomainObject_Known_NonRelative(domainObjectCriteria);
        }
        if (domainObjectCriteria.getKnownMainIdList() == null || domainObjectCriteria.getKnownMainIdList().isEmpty()) {
            return this.domainObjectRepositoy.listDomainObject_HasRelative(domainObjectCriteria);
        }
        return this.domainObjectRepositoy.listDomainObject_Known_HasRelative(domainObjectCriteria);
    }
}

