/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import x7.core.bean.BeanElement;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.CriteriaCondition;
import x7.core.bean.Parsed;
import x7.core.bean.Predicate;
import x7.core.bean.condition.RefreshCondition;
import x7.core.util.BeanUtil;
import x7.core.util.BeanUtilX;
import x7.core.util.ExceptionUtil;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.repository.CriteriaParser;
import x7.repository.exception.PersistenceException;
import x7.repository.util.SqlParserUtil;

public class SqlUtil {
    protected static void adpterSqlKey(PreparedStatement pstmt, String keyOne, Object obj, int i) {
        Method method = null;
        try {
            method = obj.getClass().getDeclaredMethod(BeanUtil.getGetter((String)keyOne), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = obj.getClass().getSuperclass().getDeclaredMethod(BeanUtil.getGetter((String)keyOne), new Class[0]);
            }
            catch (Exception ee) {
                throw new RuntimeException(ExceptionUtil.getMessage((Exception)ee));
            }
        }
        try {
            Object value = method.invoke(obj, new Object[0]);
            pstmt.setObject(i++, value);
        }
        catch (Exception e) {
            throw new PersistenceException(ExceptionUtil.getMessage((Exception)e));
        }
    }

    protected static void adpterSqlKey(PreparedStatement pstmt, Field keyOneF, Object obj, int i) {
        try {
            pstmt.setObject(i++, obj);
        }
        catch (Exception e) {
            throw new PersistenceException(ExceptionUtil.getMessage((Exception)e));
        }
    }

    protected static String concat(Parsed parsed, String sql, Map<String, Object> queryMap) {
        StringBuilder sb = new StringBuilder();
        boolean flag = sql.contains(" WHERE ") || sql.contains(" WHERE ".toLowerCase());
        for (String key : queryMap.keySet()) {
            String mapper = parsed.getMapper(key);
            if (flag) {
                sb.append(Conjunction.AND.sql()).append(mapper).append(" = ?");
                continue;
            }
            sb.append(" WHERE ").append(mapper).append(" = ?");
            flag = true;
        }
        sql = sql + sb.toString();
        return sql;
    }

    protected static String concatRefresh(StringBuilder sb, Parsed parsed, RefreshCondition refreshCondition, CriteriaParser criteriaParser) {
        sb.append(" SET ");
        List refreshList = refreshCondition.getRefreshList();
        ArrayList<Object> refreshValueList = new ArrayList<Object>();
        boolean isNotFirst = false;
        for (Criteria.X x : refreshList) {
            String key;
            if (x.getPredicate() == Predicate.X) {
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                key = x.getKey();
                String str = key.toString();
                String sql = BeanUtilX.normalizeSql((String)str);
                sql = SqlParserUtil.mapper(sql, parsed);
                sb.append(sql);
                continue;
            }
            key = x.getKey();
            if (key.contains("?")) {
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                String sql = BeanUtilX.normalizeSql((String)key);
                sql = SqlParserUtil.mapper(sql, parsed);
                sb.append(sql);
            } else {
                Object v;
                if (StringUtil.isNullOrEmpty((String)x.getValue().toString()) || BeanUtilX.isBaseType_0((String)key, (Object)x.getValue(), (Parsed)parsed)) continue;
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                String mapper = parsed.getMapper(key);
                sb.append(mapper);
                sb.append(" = ?");
                BeanElement be = (BeanElement)parsed.getElementMap().get(key);
                if (be.clz == Date.class) {
                    if (x.getValue() instanceof Long) {
                        x.setValue((Object)new Date((Long)x.getValue()));
                    }
                } else if (be.clz == Timestamp.class) {
                    if (x.getValue() instanceof Long) {
                        x.setValue((Object)new Timestamp((Long)x.getValue()));
                    }
                } else if (be.isJson && (v = x.getValue()) != null) {
                    String str = JsonX.toJson((Object)v);
                    x.setValue((Object)str);
                }
            }
            Object v = x.getValue();
            if (v instanceof Enum) {
                String name = ((Enum)v).name();
                x.setValue((Object)name);
            }
            refreshValueList.add(x.getValue());
        }
        Criteria condition = refreshCondition.getCondition();
        if (!refreshValueList.isEmpty()) {
            condition.getValueList().addAll(0, refreshValueList);
        }
        String conditionSql = criteriaParser.parseCondition((CriteriaCondition)condition);
        conditionSql = SqlParserUtil.mapper(conditionSql, parsed);
        sb.append(conditionSql);
        return sb.toString();
    }

    protected static void adpterRefreshCondition(PreparedStatement pstmt, int i, CriteriaCondition condition) {
        if (Objects.nonNull(condition)) {
            for (Object v : condition.getValueList()) {
                SqlUtil.setValue(i, pstmt, v);
                ++i;
            }
        }
    }

    public static void setValue(int i, PreparedStatement pstmt, Object obj) {
        try {
            if (Objects.nonNull(obj) && obj.getClass().isEnum()) {
                pstmt.setObject(i, ((Enum)obj).name());
            } else {
                pstmt.setObject(i, obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
        }
    }
}

