/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import x7.core.bean.BeanElement;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.config.ConfigAdapter;
import x7.core.util.ExceptionUtil;
import x7.repository.CriteriaParser;
import x7.repository.KeyOne;
import x7.repository.dao.Dao;
import x7.repository.dao.DataSourceUtil;
import x7.repository.dao.IdBuildable;
import x7.repository.dao.RcDataSourceUtil;
import x7.repository.dao.SqlUtil;
import x7.repository.dao.StatementBuildable;
import x7.repository.exception.PersistenceException;
import x7.repository.exception.RollbackException;
import x7.repository.mapper.Mapper;
import x7.repository.mapper.MapperFactory;
import x7.repository.util.ResultSetUtil;
import x7.repository.util.SqlParserUtil;

public class DaoTemplate {
    private static final Logger logger = LoggerFactory.getLogger(Dao.class);
    @Autowired
    private DaoTemplate template;
    @Autowired
    private CriteriaParser criteriaParser;
    @Autowired
    private Mapper.Dialect dialect;

    public void setDialect(Mapper.Dialect dialect) {
        this.dialect = dialect;
    }

    public void setCriteriaParser(CriteriaParser criteriaParser) {
        this.criteriaParser = criteriaParser;
    }

    private static void close(Connection conn) {
        RcDataSourceUtil.releaseConnection(conn);
    }

    private static void close(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public long execute(String sql, StatementBuildable statementBuilder, IdBuildable idBuilder) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        long id = 0L;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            statementBuilder.buildStatement(pstmt);
            pstmt.execute();
            id = idBuilder.buildId(pstmt);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RollbackException("RollbackException: " + e.getMessage());
        }
        finally {
            DaoTemplate.close(pstmt);
            DataSourceUtil.releaseConnection(conn);
        }
        return id;
    }

    public boolean executeUpdate(String sql, StatementBuildable statementBuilder) {
        boolean flag;
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            statementBuilder.buildStatement(pstmt);
            flag = pstmt.executeUpdate() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RollbackException("RollbackException: " + e.getMessage());
        }
        finally {
            DaoTemplate.close(pstmt);
            DataSourceUtil.releaseConnection(conn);
        }
        return flag;
    }

    public ResultSet executeQuery(String sql, StatementBuildable statementBuilder) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            statementBuilder.buildStatement(pstmt);
            rs = pstmt.executeQuery();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("RollbackException: " + e.getMessage());
            }
            catch (Throwable throwable) {
                DaoTemplate.close(pstmt);
                DataSourceUtil.releaseConnection(conn);
                throw throwable;
            }
        }
        DaoTemplate.close(pstmt);
        DataSourceUtil.releaseConnection(conn);
        return rs;
    }

    public <T> List<T> list(Object conditionObj) {
        ResultSet rs;
        Class<?> clz = conditionObj.getClass();
        String sql = MapperFactory.getSql(clz, "LOAD");
        Parsed parsed = Parser.get(clz);
        final Map<String, Object> queryMap = SqlParserUtil.getQueryMap(parsed, conditionObj);
        sql = SqlUtil.concat(parsed, sql, queryMap);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        if ((rs = this.executeQuery(sql, new StatementBuildable(){

            @Override
            public void buildStatement(PreparedStatement pstmt) {
                int i = 1;
                try {
                    for (Object value : queryMap.values()) {
                        value = DaoTemplate.this.dialect.filterValue(value);
                        DaoTemplate.this.dialect.setObject(i++, value, pstmt);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
                }
            }
        })) == null) {
            return null;
        }
        return null;
    }

    private <T> void initObj(T obj, ResultSet rs, BeanElement tempEle, List<BeanElement> eles) throws Exception {
        ResultSetUtil.initObj(obj, rs, tempEle, eles);
    }

    private <T> boolean testRemove(final KeyOne<T> keyOne) {
        Class<T> clz = keyOne.getClzz();
        Parsed parsed = Parser.get(clz);
        final int i = 1;
        final Field keyOneField = parsed.getKeyField(1);
        if (Objects.isNull(keyOneField)) {
            throw new PersistenceException("No setting of PrimaryKey by @X.Key");
        }
        String sql = MapperFactory.getSql(clz, "REMOVE");
        return this.executeUpdate(sql, new StatementBuildable(){

            @Override
            public void buildStatement(PreparedStatement pstmt) {
                SqlUtil.adpterSqlKey(pstmt, keyOneField, keyOne.get(), i);
            }
        });
    }
}

