/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.cache;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import x7.core.exception.DistributionLockException;
import x7.core.util.ExceptionUtil;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.distributed.DistributionLock;
import x7.repository.cache.L3CacheStoragePolicy;
import x7.repository.exception.L3CacheException;

public interface L3CacheResolver {
    public L3CacheStoragePolicy getStorage();

    default public String resolve(String key, long expireTime, TimeUnit timeUnit, Callable caller) {
        try {
            String value = this.getStorage().get(key, expireTime, timeUnit);
            if (StringUtil.isNotNull((String)value)) {
                PeriodCounter.reset(key);
                if ("NULL".equals(value)) {
                    return null;
                }
                return value;
            }
        }
        catch (Exception e) {
            PeriodCounter.reset(key);
            throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
        }
        try {
            return DistributionLock.by(key + "~look").lock(t -> {
                try {
                    Object obj = caller.call();
                    String str = JsonX.toJson(obj);
                    this.getStorage().set(key, str, expireTime, timeUnit);
                    String string = str;
                    return string;
                }
                catch (Throwable e) {
                    throw new RuntimeException(ExceptionUtil.getMessage((Throwable)e));
                }
                finally {
                    PeriodCounter.reset(key);
                }
            });
        }
        catch (DistributionLockException dle) {
            PeriodCounter.increment(key);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                PeriodCounter.reset(key);
                throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
            }
            return this.resolve(key, expireTime, timeUnit, caller);
        }
        catch (Exception e) {
            PeriodCounter.reset(key);
            throw new RuntimeException(ExceptionUtil.getMessage((Exception)e));
        }
    }

    public static class PeriodCounter {
        private static final Map<String, Long> countMap = new ConcurrentHashMap<String, Long>();
        private static final long MAX_COUNT = 40L;
        private static final long SLEEP_MILLIS = 300L;

        private static void increment(String key) {
            long count = MapUtils.getLongValue(countMap, (Object)(key = PeriodCounter.wrapKey(key)));
            if (count >= 40L) {
                PeriodCounter.reset(key);
                throw new L3CacheException("SERVER BUSY");
            }
            countMap.put(key, count + 1L);
        }

        private static void reset(String key) {
            key = PeriodCounter.wrapKey(key);
            countMap.remove(key);
        }

        private static String wrapKey(String key) {
            String threadId = String.valueOf(Thread.currentThread().getId());
            String k = key + "." + threadId;
            return k;
        }
    }
}

