/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.cache;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Value;
import x7.core.repository.CacheableL3;
import x7.core.util.ExceptionUtil;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.repository.cache.ArgsToString;
import x7.repository.cache.L3CacheResolver;

@Aspect
public class L3CacheAspect {
    @Value(value="${x7.cache.l3.expire-time:'6000ms'}")
    private String expireTime = "6000ms";
    private ArgsToString argsToString;
    private L3CacheResolver resolver;

    private long getExpireTime() {
        this.expireTime = this.expireTime.toLowerCase();
        if (this.expireTime.contains("ms")) {
            this.expireTime = this.expireTime.replace("ms", "");
            return Long.valueOf(this.expireTime);
        }
        if (this.expireTime.contains("s")) {
            this.expireTime = this.expireTime.replace("s", "");
            return Long.valueOf(this.expireTime) * 1000L;
        }
        if (this.expireTime.contains("m")) {
            this.expireTime = this.expireTime.replace("m", "");
            return Long.valueOf(this.expireTime) * 1000L * 60L;
        }
        if (this.expireTime.contains("h")) {
            this.expireTime = this.expireTime.replace("h", "");
            return Long.valueOf(this.expireTime) * 1000L * 60L * 60L;
        }
        if (this.expireTime.contains("d")) {
            this.expireTime = this.expireTime.replace("d", "");
            return Long.valueOf(this.expireTime) * 1000L * 60L * 60L * 24L;
        }
        try {
            return Long.valueOf(this.expireTime);
        }
        catch (Exception e) {
            return 6000L;
        }
    }

    public void setArgsToString(ArgsToString argsToString) {
        this.argsToString = argsToString;
    }

    public void setResolver(L3CacheResolver resolver) {
        this.resolver = resolver;
    }

    @Pointcut(value="@annotation(x7.core.repository.CacheableL3))")
    public void cut() {
    }

    @Around(value="cut() && @annotation(cacheableL3) ")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, CacheableL3 cacheableL3) {
        String value;
        Signature signature = proceedingJoinPoint.getSignature();
        MethodSignature ms = (MethodSignature)signature;
        String methodName = ms.toShortString();
        Class returnType = ms.getReturnType();
        try {
            if (returnType == Void.TYPE) {
                proceedingJoinPoint.proceed();
                return null;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(ExceptionUtil.getMessage((Throwable)e));
        }
        Object[] argArr = proceedingJoinPoint.getArgs();
        String key = this.argsToString.get(methodName, argArr);
        long expireTime = cacheableL3.expireTime();
        TimeUnit timeUnit = cacheableL3.timeUnit();
        if (expireTime == 0L) {
            expireTime = this.getExpireTime();
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (StringUtil.isNullOrEmpty((String)(value = this.resolver.resolve(key, expireTime, timeUnit, () -> {
            try {
                return proceedingJoinPoint.proceed();
            }
            catch (Throwable e) {
                throw new RuntimeException(ExceptionUtil.getMessage((Throwable)e));
            }
        })))) {
            return null;
        }
        if (returnType == List.class) {
            Type gt = ms.getMethod().getGenericReturnType();
            ParameterizedType pt = (ParameterizedType)gt;
            Type[] tt = pt.getActualTypeArguments();
            Type t = tt[0];
            if (t instanceof ParameterizedType) {
                return JSON.parseArray((String)value, (Type[])tt);
            }
            Class genericClz = (Class)t;
            return JsonX.toList((String)value, (Class)genericClz);
        }
        return JsonX.toObject((String)value, (Class)returnType);
    }
}

