/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import x7.core.util.StringUtil;
import x7.repository.cache.L3CacheStoragePolicy;

public class DefaultL3CacheStoragePolicy
implements L3CacheStoragePolicy {
    private StringRedisTemplate stringRedisTemplate;

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void set(String key, String value, long expireTime, TimeUnit timeUnit) {
        value = value == null ? "NULL" : value;
        PluginL1.putBeforeL3(key, value, expireTime, timeUnit);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, expireTime, timeUnit);
    }

    @Override
    public String get(String key, long expireTime, TimeUnit timeUnit) {
        String value = PluginL1.get(key);
        if (StringUtil.isNullOrEmpty((String)value) && StringUtil.isNotNull((String)(value = (String)this.stringRedisTemplate.opsForValue().get((Object)key)))) {
            PluginL1.putBeforeL3(key, value, expireTime, timeUnit);
        }
        return value;
    }

    public static class PluginL1 {
        private static final Map<String, Wrapper> map = new ConcurrentHashMap<String, Wrapper>();
        private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

        private static long convertToMillisForL1(long expireTime, TimeUnit timeUnit) {
            long time = TimeUnit.MILLISECONDS.convert(expireTime, timeUnit);
            if (time <= 2000L) {
                return time / 2L;
            }
            if (time <= 6000L) {
                return time / 3L;
            }
            if (time <= 16000L) {
                return time / 4L;
            }
            if (time <= 30000L) {
                return time / 5L;
            }
            return 6000L;
        }

        public static void putBeforeL3(String key, String value, long expireTime, TimeUnit timeUnit) {
            long expire = PluginL1.convertToMillisForL1(expireTime, timeUnit);
            PluginL1.put(key, value, expire);
        }

        public static void put(String key, String value, long expire) {
            PluginL1.remove(key);
            if (expire > 0L) {
                ScheduledFuture<?> future = executor.schedule(() -> map.remove(key), expire, TimeUnit.MILLISECONDS);
                map.put(key, new Wrapper(value, future));
            } else {
                map.put(key, new Wrapper(value, null));
            }
        }

        public static String get(String key) {
            Wrapper Wrapper2 = map.get(key);
            return Wrapper2 == null ? null : Wrapper2.getValue();
        }

        public static String remove(String key) {
            Wrapper Wrapper2 = map.remove(key);
            if (Wrapper2 == null) {
                return null;
            }
            Future future = Wrapper2.getFuture();
            if (future != null) {
                future.cancel(true);
            }
            return Wrapper2.getValue();
        }

        private static class Wrapper {
            private String value;
            private Future future;

            public Wrapper(String value, Future future) {
                this.value = value;
                this.future = future;
            }

            public String getValue() {
                return this.value;
            }

            public Future getFuture() {
                return this.future;
            }

            public String toString() {
                return "Wrapper{value=" + this.value + ", future=" + this.future + '}';
            }
        }
    }
}

