/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.cache;

import java.util.List;
import java.util.Set;
import org.springframework.data.redis.core.StringRedisTemplate;
import x7.repository.cache.L2CacheStoragePolicy;

public class DefaultL2CacheStoragePolicy
implements L2CacheStoragePolicy {
    private StringRedisTemplate stringRedisTemplate;

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public boolean set(String key, String value) {
        if (key == null || key.equals("")) {
            return false;
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    @Override
    public boolean set(String key, String value, int validSeconds) {
        if (key == null || key.equals("")) {
            return false;
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, (long)validSeconds);
        return true;
    }

    @Override
    public String get(String key) {
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (str == null) {
            return str;
        }
        return str.trim();
    }

    @Override
    public List<String> multiGet(List<String> keyList) {
        if (keyList == null || keyList.isEmpty()) {
            return null;
        }
        List list = this.stringRedisTemplate.opsForValue().multiGet(keyList);
        if (list == null) {
            return null;
        }
        return list;
    }

    @Override
    public boolean delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
        return true;
    }

    @Override
    public Set<String> keys(String pattern) {
        Set set = this.stringRedisTemplate.keys((Object)pattern);
        return set;
    }
}

