/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.exception.CacheException;
import x7.core.repository.CacheResolver;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.core.util.VerifyUtil;
import x7.core.web.Page;
import x7.repository.cache.L2CacheStoragePolicy;
import x7.repository.cache.ObjectUtil;
import x7.repository.exception.PersistenceException;

public class DefaultL2CacheResolver
implements CacheResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultL2CacheResolver.class);
    public static final String NANO_SECOND = ".ns.";
    private static int validSecond;
    private static boolean isEnabled;
    private L2CacheStoragePolicy cacheStoragePolicy;

    public static void enabled() {
        isEnabled = true;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public static void setValidSecond(int vs) {
        validSecond = vs;
        System.out.println("\n");
        logger.info("L2 Cache try to starting.... cache time = " + validSecond + "s");
        System.out.println("\n");
    }

    private int getValidSecondAdjusted() {
        return validSecond;
    }

    public void setCacheStoragePolicy(L2CacheStoragePolicy cacheStoragePolicy) {
        this.cacheStoragePolicy = cacheStoragePolicy;
    }

    public String markForRefresh(Class clz) {
        String time;
        String key = this.getNSKey(clz);
        boolean flag = this.cacheStoragePolicy.set(key, time = String.valueOf(System.nanoTime()));
        if (!flag) {
            throw new CacheException("markForRefresh failed");
        }
        return time;
    }

    public void remove(Class clz, String key) {
        boolean flag = this.cacheStoragePolicy.delete(key = this.getSimpleKey(clz, key));
        if (!flag) {
            throw new CacheException("remove failed");
        }
    }

    public void remove(Class clz) {
        String key = this.getSimpleKeyLike(clz);
        Set<String> keySet = this.cacheStoragePolicy.keys(key);
        for (String k : keySet) {
            boolean flag = this.cacheStoragePolicy.delete(k);
            if (flag) continue;
            throw new CacheException("remove failed");
        }
    }

    private String getNSKey(Class clz) {
        return clz.getName() + NANO_SECOND;
    }

    private String getNS(String nsKey) {
        return this.cacheStoragePolicy.get(nsKey);
    }

    private List<String> getKeyList(Class clz, List<String> conditionList) {
        if (conditionList == null || conditionList.isEmpty()) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String condition : conditionList) {
            String key = this.getSimpleKey(clz, condition);
            keyList.add(key);
        }
        if (keyList.isEmpty()) {
            return null;
        }
        return keyList;
    }

    private String getSimpleKey(Class clz, String condition) {
        return "{" + clz.getName() + "}." + condition;
    }

    private String getSimpleKeyLike(Class clz) {
        return "{" + clz.getName() + "}.*";
    }

    private String getKey(Class clz, Object conditionObj) {
        String condition = JsonX.toJson((Object)conditionObj);
        long startTime = System.currentTimeMillis();
        String key = this.getPrefix(clz) + "." + VerifyUtil.toMD5((String)condition);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultL2CacheResolver.getKey() cost time = " + (endTime - startTime) + "s");
        }
        return key;
    }

    private String getPrefix(Class clz) {
        String key = this.getNSKey(clz);
        String nsStr = this.cacheStoragePolicy.get(key);
        if (nsStr == null) {
            String str = this.markForRefresh(clz);
            return "{" + clz.getName() + "}." + str;
        }
        return "{" + clz.getName() + "}." + nsStr;
    }

    public void set(Class clz, String key, Object obj) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        this.cacheStoragePolicy.set(key, JsonX.toJson((Object)obj), validSecond);
    }

    public void setResultKeyList(Class clz, Object condition, List<String> keyList) {
        String key = this.getKey(clz, condition);
        try {
            this.cacheStoragePolicy.set(key, JsonX.toJson(keyList), validSecond);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public <T> void setResultKeyListPaginated(Class<T> clz, Object condition, Page<T> pagination) {
        String key = this.getKey(clz, condition);
        try {
            this.cacheStoragePolicy.set(key, JsonX.toJson(pagination), validSecond);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public List<String> getResultKeyList(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        String str = this.cacheStoragePolicy.get(key);
        if (StringUtil.isNullOrEmpty((String)str)) {
            return new ArrayList<String>();
        }
        return JsonX.toList((String)str, String.class);
    }

    public Page<String> getResultKeyListPaginated(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        String json = this.cacheStoragePolicy.get(key);
        if (StringUtil.isNullOrEmpty((String)json)) {
            return null;
        }
        return ObjectUtil.toPagination(json);
    }

    public <T> List<T> list(Class<T> clz, List<String> keyList) {
        List<String> keyArr = this.getKeyList(clz, keyList);
        List<String> jsonList = this.cacheStoragePolicy.multiGet(keyArr);
        if (jsonList == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String json : jsonList) {
            if (!StringUtil.isNotNull((String)json)) continue;
            Object t = JsonX.toObject((String)json, clz);
            list.add(t);
        }
        return list;
    }

    public <T> T get(Class<T> clz, String key) {
        String str = this.cacheStoragePolicy.get(key = this.getSimpleKey(clz, key));
        if (StringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        Object obj = JsonX.toObject((String)str, clz);
        return (T)obj;
    }

    public void setMapList(Class clz, String key, List<Map<String, Object>> mapList) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        this.cacheStoragePolicy.set(key, JsonX.toJson(mapList), validSecond);
    }

    public List<Map<String, Object>> getMapList(Class clz, String key) {
        String str = this.cacheStoragePolicy.get(key = this.getSimpleKey(clz, key));
        if (StringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        List mapList = JsonX.toList((String)str, Map.class);
        return mapList;
    }
}

