/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.bean.Criteria;
import x7.core.bean.CriteriaBuilder;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.condition.InCondition;
import x7.core.bean.condition.RefreshCondition;
import x7.core.repository.CacheResolver;
import x7.core.util.BeanUtilX;
import x7.core.util.JsonX;
import x7.core.web.Page;
import x7.repository.KeyOne;
import x7.repository.ManuRepository;
import x7.repository.Repository;
import x7.repository.transform.DataTransform;

public class CacheableRepository
implements Repository {
    private static final Logger logger = LoggerFactory.getLogger(Repository.class);
    private DataTransform dataTransform;
    private CacheResolver cacheResolver;

    public CacheableRepository() {
        ManuRepository.init(this);
    }

    public void setDataTransform(DataTransform dataTransform) {
        logger.info("X7 Repository on starting....");
        this.dataTransform = dataTransform;
    }

    public void setCacheResolver(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    private boolean isNoCache() {
        return !this.cacheResolver.isEnabled();
    }

    private String getCacheKey(Object obj, Parsed parsed) {
        try {
            Field field = obj.getClass().getDeclaredField(parsed.getKey(1));
            field.setAccessible(true);
            String keyOne = field.get(obj).toString();
            return keyOne;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> void replenishAndRefreshCache(List<String> keyList, List<T> list, Class<T> clz, Parsed parsed) {
        HashSet<String> keySet = new HashSet<String>();
        for (T t : list) {
            String key = this.getCacheKey(t, parsed);
            keySet.add(key);
        }
        for (String key : keyList) {
            if (keySet.contains(key)) continue;
            Object obj = null;
            Field f = parsed.getKeyField(1);
            Object condition = null;
            try {
                condition = clz.newInstance();
                f.set(condition, key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            obj = this.dataTransform.getOne(condition);
            if (obj == null) {
                if (this.isNoCache() || parsed.isNoCache()) continue;
                this.cacheResolver.markForRefresh(clz);
                continue;
            }
            list.add(obj);
            if (this.isNoCache() || parsed.isNoCache()) continue;
            this.cacheResolver.set(clz, key, obj);
        }
    }

    private <T> List<T> sort(List<String> keyList, List<T> list, Parsed parsed) {
        ArrayList<T> sortedList = new ArrayList<T>();
        block0: for (String key : keyList) {
            Iterator<T> ite = list.iterator();
            while (ite.hasNext()) {
                T t = ite.next();
                if (!key.equals(this.getCacheKey(t, parsed))) continue;
                ite.remove();
                sortedList.add(t);
                continue block0;
            }
        }
        return sortedList;
    }

    @Override
    public long create(Object obj) {
        Class<?> clz = obj.getClass();
        Parsed parsed = Parser.get(clz);
        long id = this.dataTransform.create(obj);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
        return id;
    }

    @Override
    public <T> boolean refresh(RefreshCondition<T> refreshCondition) {
        boolean flag = false;
        Criteria condition = refreshCondition.getCondition();
        Class clz = refreshCondition.getClz();
        if (condition instanceof Criteria) {
            Criteria criteria = condition;
            criteria.setClz(refreshCondition.getClz());
        }
        Parsed parsed = Parser.get((Class)clz);
        flag = this.dataTransform.refresh(refreshCondition);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.remove(clz);
            this.cacheResolver.markForRefresh(clz);
            String keyOne = parsed.getKey(1);
            Object pk = null;
            for (Criteria.X x : refreshCondition.getCondition().getListX()) {
                String key = x.getKey();
                if (key == null || !key.equals(keyOne)) continue;
                pk = x.getValue();
            }
            if (pk != null) {
                this.cacheResolver.remove(clz, String.valueOf(pk));
            }
        }
        return flag;
    }

    @Override
    public <T> void refreshCache(Class<T> clz) {
        Parsed parsed = Parser.get(clz);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
    }

    @Override
    public <T> boolean remove(KeyOne<T> keyOne) {
        boolean flag = false;
        Class<T> clz = keyOne.getClzz();
        Parsed parsed = Parser.get(clz);
        String key = String.valueOf(keyOne.get());
        flag = this.dataTransform.remove(keyOne);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            if (key != null) {
                this.cacheResolver.remove(clz, key);
            }
            this.cacheResolver.markForRefresh(clz);
        }
        return flag;
    }

    @Override
    public <T> List<T> list(Object conditionObj) {
        if (conditionObj instanceof CriteriaBuilder || conditionObj instanceof Criteria) {
            throw new RuntimeException("Notes: parameter is not Criteria");
        }
        Class<?> clz = conditionObj.getClass();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.dataTransform.list(conditionObj);
        }
        List list = null;
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, conditionObj);
        if (keyList == null || keyList.isEmpty()) {
            list = this.dataTransform.list(conditionObj);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, conditionObj, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public <T> T getOne(T conditionObj) {
        Class<?> clz = conditionObj.getClass();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            T t = this.dataTransform.getOne(conditionObj);
            return t;
        }
        String condition = JsonX.toJson(conditionObj);
        Object obj = this.cacheResolver.get(clz, condition);
        if (obj == null) {
            obj = this.dataTransform.getOne(conditionObj);
            this.cacheResolver.set(clz, condition, obj);
            return (T)obj;
        }
        return (T)obj;
    }

    @Override
    public <T> Page<T> find(Criteria criteria) {
        Class clz = criteria.getClz();
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache()) {
            return this.dataTransform.find(criteria);
        }
        List list = null;
        Page p = this.cacheResolver.getResultKeyListPaginated(clz, (Object)criteria);
        if (p == null) {
            this.dataTransform.find(criteria);
            list = p.getList();
            List keyList = p.getKeyList();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            p.reSetList(null);
            this.cacheResolver.setResultKeyListPaginated(clz, (Object)criteria, p);
            p.setKeyList(null);
            p.reSetList(list);
            return p;
        }
        List keyList = p.getKeyList();
        if (keyList == null || keyList.isEmpty()) {
            return p;
        }
        list = this.cacheResolver.list(clz, keyList);
        if (keyList.size() == list.size()) {
            p.reSetList(list);
            return p;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        p.reSetList(sortedList);
        return p;
    }

    @Override
    public <T> List<T> list(Criteria criteria) {
        Class clz = criteria.getClz();
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache()) {
            return this.dataTransform.list(criteria);
        }
        List list = null;
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, (Object)criteria);
        if (keyList == null || keyList.isEmpty()) {
            list = this.dataTransform.list(criteria);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, (Object)criteria, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    protected <T> boolean execute(T obj, String sql) {
        Parsed parsed = Parser.get(obj.getClass());
        boolean b = this.dataTransform.execute(obj, sql);
        if (b) {
            String key = this.getCacheKey(obj, parsed);
            if (!this.isNoCache() && !parsed.isNoCache() && key != null) {
                this.cacheResolver.remove(obj.getClass(), key);
            }
        }
        return b;
    }

    protected <T> List<T> in0(InCondition inCondition) {
        Class clz = inCondition.getClz();
        String inProperty = inCondition.getProperty();
        Parsed parsed = Parser.get((Class)clz);
        List inList = inCondition.getInList();
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.dataTransform.in(inCondition);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(inProperty).append(":");
        for (Object obj : inList) {
            sb.append(obj.toString()).append("_");
        }
        String condition = sb.toString();
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, (Object)condition);
        List list = null;
        if (keyList == null || keyList.isEmpty()) {
            list = this.dataTransform.in(inCondition);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, (Object)condition, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public <T> List<T> in(InCondition inCondition) {
        Parsed parsed = Parser.get((Class)inCondition.getClz());
        if (inCondition.getInList().isEmpty()) {
            return new ArrayList();
        }
        ArrayList inList = new ArrayList();
        for (Object obj : inCondition.getInList()) {
            if (Objects.isNull(obj) || BeanUtilX.isBaseType_0((String)inCondition.getProperty(), obj, (Parsed)parsed) || inList.contains(obj)) continue;
            inList.add(obj);
        }
        if (inList.isEmpty()) {
            return new ArrayList();
        }
        int size = inList.size();
        if (size <= 500) {
            inCondition.setInList(inList);
            return this.in0(inCondition);
        }
        ArrayList<T> list = new ArrayList<T>(size);
        int i = 0;
        while (size > 0) {
            int segSize = size > 500 ? 500 : size;
            size -= segSize;
            int fromIndex = i++ * 500;
            int toIndex = fromIndex + segSize;
            List segInList = inList.subList(fromIndex, toIndex);
            InCondition ic = new InCondition(inCondition.getProperty(), segInList);
            ic.setClz(inCondition.getClz());
            List<T> segList = this.in0(ic);
            list.addAll(segList);
        }
        return list;
    }

    @Override
    public Page<Map<String, Object>> find(Criteria.ResultMappedCriteria resultMapped) {
        return this.dataTransform.find(resultMapped);
    }

    @Override
    public List<Map<String, Object>> list(Criteria.ResultMappedCriteria resultMapped) {
        return this.dataTransform.list(resultMapped);
    }

    @Override
    public boolean createBatch(List<? extends Object> objList) {
        if (objList.isEmpty()) {
            return false;
        }
        Class<?> clz = objList.get(0).getClass();
        Parsed parsed = Parser.get(clz);
        boolean flag = this.dataTransform.createBatch(objList);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
        return flag;
    }

    protected List<Map<String, Object>> list(Class clz, String sql, List<Object> conditionList) {
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.dataTransform.list(clz, sql, conditionList);
        }
        String condition = sql + conditionList.toString();
        List<Map<String, Object>> mapList = this.cacheResolver.getMapList(clz, condition);
        if (mapList == null && (mapList = this.dataTransform.list(clz, sql, conditionList)) != null) {
            this.cacheResolver.setMapList(clz, condition, mapList);
        }
        return mapList;
    }
}

