/*
 * Decompiled with CFR 0.152.
 */
package x7.distributed;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.exception.DistributionLockException;
import x7.distributed.LockStorage;

public class DistributionLock {
    private static Logger logger = LoggerFactory.getLogger(DistributionLock.class);
    private static LockStorage lockStorage;

    protected static void init(LockStorage ls) {
        lockStorage = ls;
    }

    private static void lock(String key) {
        boolean locked = lockStorage.lock(key);
        if (!locked) {
            logger.info("Get distributed lock failed, lockKey: " + key);
            throw new DistributionLockException();
        }
    }

    private static void unLock(String key) {
        lockStorage.unLock(key);
    }

    private static void unLockAsync(String key) {
    }

    public static Lock by(String key) {
        Lock ml = new Lock();
        ml.setKey(key);
        return ml;
    }

    public static interface Task<T> {
        public T run(Object var1);
    }

    public static class Lock {
        private String key;

        private void setKey(String key) {
            this.key = key;
        }

        public <T> T lock(Task<T> obj) {
            DistributionLock.lock(this.key);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this.key);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLock(this.key);
            }
            return o;
        }

        public <T> T lockAsync(Task<T> obj) {
            DistributionLock.lock(this.key);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this.key);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLockAsync(this.key);
            }
            return o;
        }
    }
}

