/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import x7.core.bean.BeanElement;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.condition.InCondition;
import x7.core.bean.condition.ReduceCondition;
import x7.core.bean.condition.RefreshCondition;
import x7.core.config.ConfigAdapter;
import x7.core.util.BeanMapUtil;
import x7.core.util.BeanUtilX;
import x7.core.util.ExceptionUtil;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.core.web.Direction;
import x7.core.web.Page;
import x7.repository.CriteriaParser;
import x7.repository.dao.Dao;
import x7.repository.dao.DataSourceUtil;
import x7.repository.dao.RcDataSourceUtil;
import x7.repository.dao.SqlCriteriaParser;
import x7.repository.dao.SqlUtil;
import x7.repository.exception.PersistenceException;
import x7.repository.exception.RollbackException;
import x7.repository.mapper.Mapper;
import x7.repository.mapper.MapperFactory;
import x7.repository.util.ResultSetUtil;
import x7.repository.util.ResultSortUtil;

public class DaoImpl
implements Dao {
    private static DaoImpl instance;
    private CriteriaParser criteriaParser = new SqlCriteriaParser();
    @Autowired
    private Mapper.Dialect dialect;

    public static DaoImpl getInstance() {
        if (instance == null) {
            instance = new DaoImpl();
        }
        return instance;
    }

    private DaoImpl() {
    }

    public void setDialect(Mapper.Dialect dialect) {
        this.dialect = dialect;
        this.criteriaParser.setDialect(dialect);
    }

    private static void close(Connection conn) {
        RcDataSourceUtil.releaseConnection(conn);
    }

    private static void close(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean createBatch(List<? extends Object> objList) {
        if (objList.isEmpty()) {
            return false;
        }
        Object obj = objList.get(0);
        Class<?> clz = obj.getClass();
        String sql = MapperFactory.getSql(clz, "CREATE");
        List<BeanElement> eles = MapperFactory.getElementList(clz);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            Parsed parsed = Parser.get(clz);
            Long keyOneValue = 0L;
            Field keyOneField = parsed.getKeyField(1);
            if (Objects.isNull(keyOneField)) {
                throw new PersistenceException("No setting of PrimaryKey by @X.Key");
            }
            Class<?> keyOneType = keyOneField.getType();
            if (keyOneType != String.class) {
                keyOneValue = keyOneField.getLong(obj);
            }
            conn = DataSourceUtil.getConnection();
            pstmt = keyOneType != String.class && (keyOneValue == null || keyOneValue == 0L) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            for (Object object : objList) {
                int i = 1;
                for (BeanElement ele : eles) {
                    String str;
                    Object value = ele.getMethod.invoke(object, new Object[0]);
                    if (value == null) {
                        if (ele.clz.isEnum()) {
                            throw new PersistenceException("ENUM CAN NOT NULL, property:" + clz.getName() + "." + ele.getProperty());
                        }
                        if (ele.clz == Boolean.class || ele.clz == Integer.class || ele.clz == Long.class || ele.clz == Double.class || ele.clz == Float.class || ele.clz == BigDecimal.class || ele.clz == Byte.class || ele.clz == Short.class) {
                            value = 0;
                        }
                        pstmt.setObject(i++, value);
                        continue;
                    }
                    if (ele.isJson) {
                        str = JsonX.toJson((Object)value);
                        this.dialect.setJSON(i++, str, pstmt);
                        continue;
                    }
                    if (ele.clz.isEnum()) {
                        str = value.toString();
                        pstmt.setObject(i++, str);
                        continue;
                    }
                    value = this.dialect.filterValue(value);
                    pstmt.setObject(i++, value);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("RollbackException: " + ExceptionUtil.getMessage((Exception)e) + ", while create: " + obj);
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DataSourceUtil.releaseConnection(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DataSourceUtil.releaseConnection(conn);
        return true;
    }

    protected boolean remove(Object obj, Connection conn) {
        Class<?> clz = obj.getClass();
        String sql = MapperFactory.getSql(clz, "REMOVE");
        boolean flag = false;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            Parsed parsed = Parser.get(clz);
            int i = 1;
            Field keyOneField = parsed.getKeyField(1);
            if (Objects.isNull(keyOneField)) {
                throw new PersistenceException("No setting of PrimaryKey by @X.Key");
            }
            SqlUtil.adpterSqlKey(pstmt, keyOneField, obj, i);
            flag = pstmt.executeUpdate() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RollbackException("RollbackException: " + e.getMessage());
        }
        finally {
            DaoImpl.close(pstmt);
            DataSourceUtil.releaseConnection(conn);
        }
        return flag;
    }

    protected long create(Object obj, Connection conn) {
        PreparedStatement pstmt;
        long id;
        block13: {
            Class<?> clz = obj.getClass();
            String sql = MapperFactory.getSql(clz, "CREATE");
            List<BeanElement> eles = MapperFactory.getElementList(clz);
            id = -1L;
            pstmt = null;
            try {
                Parsed parsed = Parser.get(clz);
                Long keyOneValue = 0L;
                Field keyOneField = parsed.getKeyField(1);
                if (Objects.isNull(keyOneField)) {
                    throw new PersistenceException("No setting of PrimaryKey by @X.Key");
                }
                Class<?> keyOneType = keyOneField.getType();
                keyOneValue = keyOneType == String.class ? Long.valueOf(1L) : Long.valueOf(keyOneField.getLong(obj));
                pstmt = keyOneType != String.class && (keyOneValue == null || keyOneValue == 0L) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
                int i = 1;
                for (BeanElement ele : eles) {
                    String str;
                    Object value = ele.getMethod.invoke(obj, new Object[0]);
                    if (value == null) {
                        if (ele.clz.isEnum()) {
                            throw new PersistenceException("ENUM CAN NOT NULL, property:" + clz.getName() + "." + ele.getProperty());
                        }
                        if (ele.clz == Boolean.class || ele.clz == Integer.class || ele.clz == Long.class || ele.clz == Double.class || ele.clz == Float.class || ele.clz == BigDecimal.class || ele.clz == Byte.class || ele.clz == Short.class) {
                            value = 0;
                        }
                        pstmt.setObject(i++, value);
                        continue;
                    }
                    if (ele.isJson) {
                        str = JsonX.toJson((Object)value);
                        this.dialect.setJSON(i++, str, pstmt);
                        continue;
                    }
                    if (ele.clz.isEnum()) {
                        str = value.toString();
                        pstmt.setObject(i++, str);
                        continue;
                    }
                    value = this.dialect.filterValue(value);
                    pstmt.setObject(i++, value);
                }
                pstmt.execute();
                if (keyOneType != String.class && (keyOneValue == null || keyOneValue == 0L)) {
                    ResultSet rs = pstmt.getGeneratedKeys();
                    if (rs.next()) {
                        id = rs.getLong(1);
                    }
                    break block13;
                }
                id = keyOneValue;
            }
            catch (Exception e) {
                try {
                    System.out.println("Exception occured, while create: " + obj);
                    e.printStackTrace();
                    throw new RollbackException("RollbackException occoured: " + ExceptionUtil.getMessage((Exception)e) + ", while create " + obj);
                }
                catch (Throwable throwable) {
                    DaoImpl.close(pstmt);
                    DataSourceUtil.releaseConnection(conn);
                    throw throwable;
                }
            }
        }
        DaoImpl.close(pstmt);
        DataSourceUtil.releaseConnection(conn);
        return id;
    }

    protected boolean refresh(Object obj, Connection conn) {
        Class<?> clz = obj.getClass();
        Parsed parsed = Parser.get(clz);
        String tableName = parsed.getTableName();
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE").append(" ").append(tableName).append(" ");
        Map refreshMap = BeanUtilX.getRefreshMap((Parsed)parsed, (Object)obj);
        String sql = SqlUtil.concatRefresh(sb, parsed, refreshMap);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println("refresh normally: " + sql);
        }
        if (sql.contains("SET  WHERE")) {
            return false;
        }
        boolean flag = false;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            for (Object value : refreshMap.values()) {
                value = this.dialect.filterValue(value);
                this.dialect.setObject(i++, value, pstmt);
            }
            Field keyOneField = parsed.getKeyField(1);
            if (Objects.isNull(keyOneField)) {
                throw new PersistenceException("No setting of PrimaryKey by @X.Key");
            }
            SqlUtil.adpterSqlKey(pstmt, keyOneField, obj, i);
            flag = pstmt.executeUpdate() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RollbackException("RollbackException: " + e.getMessage());
        }
        finally {
            DaoImpl.close(pstmt);
            DataSourceUtil.releaseConnection(conn);
        }
        return flag;
    }

    @Override
    public long create(Object obj) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        return this.create(obj, conn);
    }

    @Override
    public boolean refresh(Object obj) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        return this.refresh(obj, conn);
    }

    @Override
    public boolean remove(Object obj) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        return this.remove(obj, conn);
    }

    protected <T> T get(Class<T> clz, long idOne, Connection conn) {
        ArrayList<T> list = new ArrayList<T>();
        String sql = MapperFactory.getSql(clz, "QUERY");
        List<BeanElement> eles = MapperFactory.getElementList(clz);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            pstmt.setObject(i++, idOne);
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    T obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ",column\uff1a" + tempEle != null ? tempEle.property + "|" + tempEle.getMapper() : ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        if (list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <T> T get(Class<T> clz, long idOne) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.get(clz, idOne, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> list(Class clz, String sql, List<Object> conditionList, Connection conn) {
        PreparedStatement pstmt;
        ArrayList<Map<String, Object>> list;
        block10: {
            sql = sql.replace("drop", " ").replace("delete", " ").replace("insert", " ").replace(";", " ");
            Parsed parsed = Parser.get((Class)clz);
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            sql = BeanUtilX.mapperForManu((String)sql, (Parsed)parsed);
            if (ConfigAdapter.isIsShowSql()) {
                System.out.println(sql);
            }
            list = new ArrayList<Map<String, Object>>();
            pstmt = null;
            try {
                ResultSet rs;
                conn.setAutoCommit(true);
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                if (conditionList != null) {
                    for (Object value : conditionList) {
                        value = this.dialect.filterValue(value);
                        this.dialect.setObject(i++, value, pstmt);
                    }
                }
                if ((rs = pstmt.executeQuery()) == null) break block10;
                while (rs.next()) {
                    HashMap<String, String> mapR = new HashMap<String, String>();
                    list.add(mapR);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int count = rsmd.getColumnCount();
                    for (i = 1; i <= count; ++i) {
                        String key = rsmd.getColumnLabel(i);
                        String value = rs.getString(i);
                        String property = parsed.getProperty(key);
                        if (StringUtil.isNullOrEmpty((String)property)) {
                            property = key;
                        }
                        mapR.put(property, value);
                    }
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DaoImpl.close(pstmt);
                    DaoImpl.close(conn);
                    throw throwable;
                }
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return list;
    }

    @Override
    public List<Map<String, Object>> list(Class clz, String sql, List<Object> conditionList) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.list(clz, sql, conditionList, conn);
    }

    @Override
    public <T> List<T> list(Class<T> clz) {
        ArrayList<T> list = new ArrayList<T>();
        String sql = MapperFactory.getSql(clz, "LOAD");
        List<BeanElement> eles = MapperFactory.getElementList(clz);
        Connection conn = null;
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn = RcDataSourceUtil.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    T obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ",column\uff1a" + tempEle != null ? tempEle.property + "|" + tempEle.getMapper() : ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return list;
    }

    protected <T> List<T> list(Object conditionObj, Connection conn) {
        Class<?> clz = conditionObj.getClass();
        String sql = MapperFactory.getSql(clz, "LOAD");
        Parsed parsed = Parser.get(clz);
        Map queryMap = BeanUtilX.getQueryMap((Parsed)parsed, (Object)conditionObj);
        sql = SqlUtil.concat(parsed, sql, queryMap);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        ArrayList list = new ArrayList();
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            for (Object value : queryMap.values()) {
                value = this.dialect.filterValue(value);
                this.dialect.setObject(i++, value, pstmt);
            }
            List eles = parsed.getBeanElementList();
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Object obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ",column\uff1a" + tempEle != null ? tempEle.property + "|" + tempEle.getMapper() : ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return list;
    }

    @Override
    public <T> List<T> list(Object conditionObj) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.list(conditionObj, conn);
    }

    protected <T> List<T> list(Criteria criteria, Connection conn) {
        Class clz = criteria.getClz();
        List valueList = criteria.getValueList();
        String[] sqlArr = this.criteriaParser.parse(criteria);
        String sql = sqlArr[1];
        int page = criteria.getPage();
        int rows = criteria.getRows();
        int start = (page - 1) * rows;
        sql = this.dialect.match(sql, start, rows);
        ArrayList list = new ArrayList();
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            for (Object value : valueList) {
                value = this.dialect.filterValue(value);
                this.dialect.setObject(i++, value, pstmt);
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                List<BeanElement> eles = MapperFactory.getElementList(clz);
                while (rs.next()) {
                    Object obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ",column\uff1a" + tempEle != null ? tempEle.property + "|" + tempEle.getMapper() : ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return list;
    }

    protected <T> Page<T> find(Criteria criteria, Connection conn) {
        PreparedStatement pstmt;
        Page pagination;
        block10: {
            Class clz = criteria.getClz();
            List valueList = criteria.getValueList();
            String[] sqlArr = this.criteriaParser.parse(criteria);
            String sql = sqlArr[1];
            int page = criteria.getPage();
            int rows = criteria.getRows();
            int start = (page - 1) * rows;
            sql = this.dialect.match(sql, start, rows);
            pagination = new Page();
            pagination.setClz(clz);
            pagination.setPage(page == 0 ? 1 : page);
            pagination.setRows(rows == 0 ? Integer.MAX_VALUE : rows);
            pagination.setOrderBy(criteria.getOrderBy());
            pagination.setDirection(criteria.getDirection());
            pagination.setScroll(criteria.isScroll());
            List list = pagination.getList();
            pstmt = null;
            BeanElement tempEle = null;
            try {
                conn.setAutoCommit(true);
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                for (Object value : valueList) {
                    value = this.dialect.filterValue(value);
                    this.dialect.setObject(i++, value, pstmt);
                }
                ResultSet rs = pstmt.executeQuery();
                if (rs == null) break block10;
                List<BeanElement> eles = MapperFactory.getElementList(clz);
                while (rs.next()) {
                    Object obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
                Parsed parsed = Parser.get((Class)clz);
                ResultSortUtil.sort(list, criteria, parsed);
                long count = 0L;
                if (!criteria.isScroll()) {
                    int size = list.size();
                    if (page == 0) {
                        count = size;
                    } else if (size > 0) {
                        String sqlCount = sqlArr[0];
                        count = this.getCount(sqlCount, valueList);
                    }
                    pagination.setTotalRows(count);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new RollbackException("Exception occured by class = " + clz.getName() + ", message: " + ExceptionUtil.getMessage((Exception)e));
                }
                catch (Throwable throwable) {
                    DaoImpl.close(pstmt);
                    DaoImpl.close(conn);
                    throw throwable;
                }
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return pagination;
    }

    @Override
    public <T> Page<T> find(Criteria criteria) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.find(criteria, conn);
    }

    @Override
    public <T> List<T> list(Criteria criteria) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.list(criteria, conn);
    }

    @Override
    public Object reduce(ReduceCondition reduceCondition) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.reduce(reduceCondition, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object reduce(ReduceCondition reduceCondition, Connection conn) {
        Object result;
        block10: {
            Class clz = reduceCondition.getClz();
            Parsed parsed = Parser.get((Class)clz);
            String conditionSql = this.criteriaParser.parseCondition(reduceCondition.getCondition());
            String type = reduceCondition.getType().toString();
            String returnStr = type.toLowerCase();
            String property = reduceCondition.getReduceProperty();
            if (StringUtil.isNotNull((String)property)) {
                property = parsed.getMapper(property);
            }
            if (Objects.isNull(property)) {
                property = "*";
            }
            String script = type + "(" + property + ")" + " " + returnStr;
            String sql = MapperFactory.getSql(clz, "LOAD");
            sql = sql.replace("*", script);
            sql = sql + conditionSql;
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            if (ConfigAdapter.isIsShowSql()) {
                System.out.println(sql);
            }
            result = null;
            PreparedStatement pstmt = null;
            try {
                conn = RcDataSourceUtil.getConnection();
                conn.setAutoCommit(true);
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                List valueList = reduceCondition.getCondition().getValueList();
                for (Object value : valueList) {
                    value = this.dialect.filterValue(value);
                    this.dialect.setObject(i++, value, pstmt);
                }
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    result = rs.getObject(returnStr);
                }
                DaoImpl.close(pstmt);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block10;
            }
            finally {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
            }
            DaoImpl.close(conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCount(String sql, Collection<Object> set) {
        long count;
        block7: {
            count = 0L;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = RcDataSourceUtil.getConnection();
                conn.setAutoCommit(true);
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                for (Object value : set) {
                    value = this.dialect.filterValue(value);
                    this.dialect.setObject(i++, value, pstmt);
                }
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getLong("count");
                }
                DaoImpl.close(pstmt);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
            }
            DaoImpl.close(conn);
        }
        return count;
    }

    @Override
    public <T> T getOne(T conditionObj, String orderBy, Direction sc) {
        Class<?> clz = conditionObj.getClass();
        String sql = MapperFactory.getSql(clz, "LOAD");
        Parsed parsed = Parser.get(clz);
        Map queryMap = BeanUtilX.getQueryMap((Parsed)parsed, conditionObj);
        sql = SqlUtil.concat(parsed, sql, queryMap);
        String mapper = BeanUtilX.getMapper((String)orderBy);
        StringBuilder sb = new StringBuilder();
        sb.append(Conjunction.ORDER_BY.sql()).append(mapper).append(" ").append(sc.toString()).append(" LIMIT ").append("1");
        sql = sql + sb.toString();
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        ArrayList list = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn = RcDataSourceUtil.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            for (Object value : queryMap.values()) {
                value = this.dialect.filterValue(value);
                this.dialect.setObject(i++, value, pstmt);
            }
            List eles = parsed.getBeanElementList();
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Object obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        if (list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    @Deprecated
    public boolean execute(Object obj, String sql) {
        Parsed parsed = Parser.get(obj.getClass());
        sql = sql.replace(" drop ", " ").replace(" delete ", " ").replace(" insert ", " ").replace(";", " ");
        sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        boolean b = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = DataSourceUtil.getConnection();
            pstmt = conn.prepareStatement(sql);
            b = pstmt.executeUpdate() != 0;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DataSourceUtil.releaseConnection(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DataSourceUtil.releaseConnection(conn);
        return b;
    }

    protected boolean refreshByCondition(RefreshCondition refreshCondition, Connection conn) {
        Class clz = refreshCondition.getClz();
        Object obj = refreshCondition.getObj();
        Parsed parsed = Parser.get((Class)clz);
        Map refreshMap = BeanUtilX.getRefreshMap((Parsed)parsed, (Object)obj);
        String tableName = parsed.getTableName();
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE").append(" ").append(tableName).append(" ");
        String sql = SqlUtil.concatRefresh(sb, parsed, refreshMap, refreshCondition, this.criteriaParser);
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println("________refreshByCondition: " + sql);
        }
        if (sql.contains("SET  WHERE")) {
            return false;
        }
        boolean flag = false;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int i = 1;
            for (Object value : refreshMap.values()) {
                value = this.dialect.filterValue(value);
                this.dialect.setObject(i++, value, pstmt);
            }
            SqlUtil.adpterRefreshCondition(pstmt, i, refreshCondition.getCondition());
            flag = pstmt.executeUpdate() != 0;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
            throw new RollbackException("Exception occured by class = " + clz.getName() + ", message: " + ExceptionUtil.getMessage((Exception)e));
        }
        finally {
            DaoImpl.close(pstmt);
            DataSourceUtil.releaseConnection(conn);
        }
        return flag;
    }

    @Override
    public <T> boolean refreshByCondition(RefreshCondition<T> refreshCondition) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("NO CONNECTION");
        }
        return this.refreshByCondition(refreshCondition, conn);
    }

    @Override
    public <T> List<T> in(InCondition inCondition) {
        Object id;
        int i;
        Class clz = inCondition.getClz();
        String inProperty = inCondition.getProperty();
        List inList = inCondition.getInList();
        Parsed parsed = Parser.get((Class)clz);
        if (StringUtil.isNullOrEmpty((String)inProperty) && Objects.isNull(inProperty = parsed.getKey(1))) {
            throw new PersistenceException("No setting of PrimaryKey by @X.Key");
        }
        BeanElement be = parsed.getElement(inProperty);
        if (be == null) {
            throw new RuntimeException("Exception in method: <T> List<T> in(inCondition), no property: " + inProperty);
        }
        String sql = MapperFactory.getSql(clz, "LOAD");
        List<BeanElement> eles = MapperFactory.getElementList(clz);
        String mapper = parsed.getMapper(inProperty);
        StringBuilder sb = new StringBuilder();
        sb.append(sql).append(" WHERE ").append(mapper);
        sb.append(" IN ").append("(");
        Class<?> keyType = be.getMethod.getReturnType();
        boolean isNumber = keyType == Long.TYPE || keyType == Integer.TYPE || keyType == Long.class || keyType == Integer.class;
        int size = inList.size();
        if (isNumber) {
            for (i = 0; i < size; ++i) {
                id = inList.get(i);
                if (id == null) continue;
                sb.append(id);
                if (i >= size - 1) continue;
                sb.append(",");
            }
        } else {
            for (i = 0; i < size; ++i) {
                id = inList.get(i);
                if (id == null || StringUtil.isNullOrEmpty((String)id.toString())) continue;
                sb.append("'").append(id).append("'");
                if (i >= size - 1) continue;
                sb.append(",");
            }
        }
        sb.append(")");
        sql = sb.toString();
        if (ConfigAdapter.isIsShowSql()) {
            System.out.println(sql);
        }
        ArrayList list = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        BeanElement tempEle = null;
        try {
            conn = RcDataSourceUtil.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Object obj = clz.newInstance();
                    list.add(obj);
                    this.initObj(obj, rs, tempEle, eles);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RollbackException("Exception occured by class = " + clz.getName() + ", message: " + ExceptionUtil.getMessage((Exception)e));
            }
            catch (Throwable throwable) {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
                throw throwable;
            }
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        return list;
    }

    @Override
    public Page<Map<String, Object>> find(Criteria.ResultMappedCriteria resultMapped) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.find(resultMapped, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page<Map<String, Object>> find(Criteria.ResultMappedCriteria resultMapped, Connection conn) {
        PreparedStatement pstmt;
        Page pagination;
        block14: {
            Page page;
            List valueList = resultMapped.getValueList();
            String[] sqlArr = this.criteriaParser.parse((Criteria)resultMapped);
            String sqlCount = sqlArr[0];
            String sql = sqlArr[1];
            int page2 = resultMapped.getPage();
            int rows = resultMapped.getRows();
            int start = (page2 - 1) * rows;
            sql = this.dialect.match(sql, start, rows);
            if (ConfigAdapter.isIsShowSql()) {
                System.out.println(sql);
            }
            pagination = new Page();
            pagination.setClz(Map.class);
            pagination.setPage(page2 == 0 ? 1 : page2);
            pagination.setRows(rows == 0 ? Integer.MAX_VALUE : rows);
            pagination.setOrderBy(resultMapped.getOrderBy());
            pagination.setDirection(resultMapped.getDirection());
            pagination.setScroll(resultMapped.isScroll());
            List list = pagination.getList();
            pstmt = null;
            try {
                String resultKey0;
                conn.setAutoCommit(true);
                pstmt = conn.prepareStatement(sql);
                int i = 1;
                for (Object value : valueList) {
                    value = this.dialect.filterValue(value);
                    this.dialect.setObject(i++, value, pstmt);
                }
                ResultSet rs = pstmt.executeQuery();
                if (rs == null) break block14;
                List resultKeyList = resultMapped.getResultKeyList();
                if (resultKeyList.isEmpty()) {
                    resultKeyList = resultMapped.listAllResultKey();
                }
                while (rs.next()) {
                    HashMap<String, Object> mapR = new HashMap<String, Object>();
                    list.add(mapR);
                    for (String property : resultKeyList) {
                        String mapper = resultMapped.getMapMapper().mapper(property);
                        Object obj = this.dialect.mappedResult(property, mapper, resultMapped.getAliaMap(), rs);
                        mapR.put(property, obj);
                    }
                }
                ResultSortUtil.sort(list, resultMapped);
                long count = 0L;
                if (!resultMapped.isScroll()) {
                    int size = pagination.getList().size();
                    if (page2 == 0) {
                        count = size;
                    } else if (size > 0) {
                        count = this.getCount(sqlCount, valueList);
                    }
                    pagination.setTotalRows(count);
                }
                if ((resultKey0 = (String)resultKeyList.get(0)).contains(".")) break block14;
                page = pagination;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DaoImpl.close(pstmt);
                    DaoImpl.close(conn);
                    throw throwable;
                }
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
            }
            DaoImpl.close(pstmt);
            DaoImpl.close(conn);
            return page;
        }
        DaoImpl.close(pstmt);
        DaoImpl.close(conn);
        List stringKeyMapList = pagination.getList();
        if (!stringKeyMapList.isEmpty()) {
            List jsonableMapList = BeanMapUtil.toJsonableMapList((List)stringKeyMapList);
            pagination.reSetList(jsonableMapList);
        }
        return pagination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> list(Criteria.ResultMappedCriteria resultMapped) {
        ArrayList<Map<String, Object>> list;
        block14: {
            PreparedStatement pstmt;
            Connection conn;
            block13: {
                ArrayList<Map<String, Object>> arrayList;
                block12: {
                    list = new ArrayList<Map<String, Object>>();
                    List valueList = resultMapped.getValueList();
                    String[] sqlArr = this.criteriaParser.parse((Criteria)resultMapped);
                    String sql = sqlArr[1];
                    int page = resultMapped.getPage();
                    int rows = resultMapped.getRows();
                    int start = (page - 1) * rows;
                    sql = this.dialect.match(sql, start, rows);
                    if (ConfigAdapter.isIsShowSql()) {
                        System.out.println(sql);
                    }
                    conn = null;
                    pstmt = null;
                    try {
                        conn = RcDataSourceUtil.getConnection();
                        conn.setAutoCommit(true);
                        pstmt = conn.prepareStatement(sql);
                        int i = 1;
                        for (Object value : valueList) {
                            value = this.dialect.filterValue(value);
                            this.dialect.setObject(i++, value, pstmt);
                        }
                        ResultSet rs = pstmt.executeQuery();
                        if (rs != null) {
                            List resultKeyList = resultMapped.getResultKeyList();
                            if (resultKeyList.isEmpty()) {
                                resultKeyList = resultMapped.listAllResultKey();
                            }
                            while (rs.next()) {
                                HashMap<String, Object> mapR = new HashMap<String, Object>();
                                list.add(mapR);
                                for (String property : resultKeyList) {
                                    String mapper = resultMapped.getMapMapper().mapper(property);
                                    Object obj = this.dialect.mappedResult(property, mapper, resultMapped.getAliaMap(), rs);
                                    mapR.put(property, obj);
                                }
                            }
                            String resultKey0 = (String)resultKeyList.get(0);
                            if (!resultKey0.contains(".")) {
                                arrayList = list;
                                DaoImpl.close(pstmt);
                                break block12;
                            }
                        }
                        DaoImpl.close(pstmt);
                        break block13;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block14;
                    }
                }
                DaoImpl.close(conn);
                return arrayList;
            }
            DaoImpl.close(conn);
            break block14;
            finally {
                DaoImpl.close(pstmt);
                DaoImpl.close(conn);
            }
        }
        if (list.isEmpty()) return list;
        return BeanMapUtil.toJsonableMapList(list);
    }

    @Override
    public <T> T getOne(T conditionObj) {
        Connection conn = RcDataSourceUtil.getConnection();
        return this.getOne(conditionObj, conn);
    }

    private <T> void initObj(T obj, ResultSet rs, BeanElement tempEle, List<BeanElement> eles) throws IllegalArgumentException, SecurityException, SQLException, IOException, IllegalAccessException, InvocationTargetException {
        ResultSetUtil.initObj(obj, rs, tempEle, eles);
    }

    protected <T> T getOne(T conditionObj, Connection conn) {
        List<T> list = this.list(conditionObj, conn);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

