/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import x7.core.async.HeartBeat;
import x7.core.async.HeartBeator;
import x7.core.bean.BeanElement;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.repository.dao.AsyncDao;
import x7.repository.dao.SqlUtil;
import x7.repository.mapper.MapperFactory;

@Component
public class AsyncDaoImpl
implements HeartBeat,
AsyncDao {
    public static int MAX_BATCH = 500;
    private static final int HEARTBEAT_DELAY = 60000;
    private long heartBeatTime = 0L;
    private final ExecutorService mainExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService inner = Executors.newSingleThreadExecutor();
    @Autowired
    private DataSource dataSource;
    private Map<Class, ArrayList<Object>> creationMap = new HashMap<Class, ArrayList<Object>>();
    private Map<Class, ArrayList<Object>> refreshMap = new HashMap<Class, ArrayList<Object>>();
    private Map<Class, ArrayList<Object>> removeMap = new HashMap<Class, ArrayList<Object>>();

    public AsyncDaoImpl() {
        HeartBeator.add((HeartBeat)this);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            System.err.println("No DataSource");
        }
        return this.dataSource.getConnection();
    }

    private static void close(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void create(final Object obj) {
        this.mainExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Class<?> clz = obj.getClass();
                AsyncDaoImpl.this.filterTryToCreate(clz);
                ArrayList<Object> objectList = (ArrayList<Object>)AsyncDaoImpl.this.creationMap.get(clz);
                if (objectList == null) {
                    objectList = new ArrayList<Object>();
                    AsyncDaoImpl.this.creationMap.put(clz, objectList);
                }
                if (!objectList.contains(obj)) {
                    objectList.add(obj);
                }
            }
        });
    }

    @Override
    public void refresh(final Object obj) {
        this.mainExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Class<?> clz = obj.getClass();
                AsyncDaoImpl.this.filterTryToCreate(clz);
                ArrayList<Object> objectList = (ArrayList<Object>)AsyncDaoImpl.this.refreshMap.get(clz);
                if (objectList == null) {
                    objectList = new ArrayList<Object>();
                    AsyncDaoImpl.this.refreshMap.put(clz, objectList);
                }
                if (!objectList.contains(obj)) {
                    objectList.add(obj);
                }
            }
        });
    }

    @Override
    public void remove(final Object obj) {
        this.mainExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Class<?> clz = obj.getClass();
                AsyncDaoImpl.this.filterTryToCreate(clz);
                ArrayList<Object> objectList = (ArrayList<Object>)AsyncDaoImpl.this.removeMap.get(clz);
                if (objectList == null) {
                    objectList = new ArrayList<Object>();
                    AsyncDaoImpl.this.removeMap.put(clz, objectList);
                }
                if (!objectList.contains(obj)) {
                    objectList.add(obj);
                }
            }
        });
    }

    private void batch() throws Exception {
        this.stepCreate();
        this.stepRefresh();
        this.stepRemove();
    }

    private void stepCreate() throws Exception {
        if (this.creationMap.size() == 0) {
            return;
        }
        final HashMap<Class, ArrayList<Object>> tempCreationMap = new HashMap<Class, ArrayList<Object>>();
        tempCreationMap.putAll(this.creationMap);
        this.creationMap.clear();
        this.inner.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncDaoImpl.this.executeCreate(tempCreationMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void executeCreate(Map<Class, ArrayList<Object>> tempMap) throws Exception {
        block0: for (Class clz : tempMap.keySet()) {
            ArrayList<Object> objList = tempMap.get(clz);
            String sql = MapperFactory.getSql(clz, "CREATE");
            List<BeanElement> eles = MapperFactory.getElementList(clz);
            int size = objList.size();
            int times = size / MAX_BATCH + 1;
            for (int i = 0; i < times; ++i) {
                int segment = 0;
                if (i + 1 == times) {
                    segment = size % MAX_BATCH;
                    if (segment == 0) {
                        continue block0;
                    }
                } else {
                    segment = MAX_BATCH;
                }
                int fromIndex = i * MAX_BATCH;
                List<Object> subList = objList.subList(fromIndex, fromIndex + segment);
                this.batchCreate(subList, sql, eles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchCreate(List<Object> objList, String sql, List<BeanElement> eles) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(sql);
            Parsed parsed = Parser.get(objList.get(0).getClass());
            for (Object obj : objList) {
                int i = 1;
                for (BeanElement ele : eles) {
                    Method method = null;
                    try {
                        method = obj.getClass().getSuperclass().getDeclaredMethod(ele.getter, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        method = obj.getClass().getDeclaredMethod(ele.getter, new Class[0]);
                    }
                    Object value = method.invoke(obj, new Object[0]);
                    pstmt.setObject(i++, value);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                pstmt.clearBatch();
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                pstmt.close();
                conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            AsyncDaoImpl.close(conn);
        }
    }

    private void stepRemove() throws Exception {
        if (this.removeMap.size() == 0) {
            return;
        }
        final HashMap<Class, ArrayList<Object>> tempRefreshMap = new HashMap<Class, ArrayList<Object>>();
        tempRefreshMap.putAll(this.removeMap);
        this.removeMap.clear();
        this.inner.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncDaoImpl.this.executeRemove(tempRefreshMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRemove(Map<Class, ArrayList<Object>> tempMap) throws Exception {
        for (Class clz : tempMap.keySet()) {
            String sql = MapperFactory.getSql(clz, "REMOVE");
            Connection conn = null;
            Statement pstmt = null;
            try {
                conn = this.getConnection();
                conn.setAutoCommit(false);
                pstmt = conn.prepareStatement(sql);
                Parsed parsed = Parser.get((Class)clz);
                String keyOne = parsed.getKey(1);
                ArrayList<Object> objList = tempMap.get(clz);
                for (Object obj : objList) {
                    int i = 1;
                    SqlUtil.adpterSqlKey((PreparedStatement)pstmt, keyOne, obj, i);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                pstmt.clearBatch();
                conn.rollback();
            }
            finally {
                try {
                    conn.setAutoCommit(true);
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                AsyncDaoImpl.close(conn);
            }
        }
    }

    private void stepRefresh() throws Exception {
        if (this.refreshMap.size() == 0) {
            return;
        }
        final HashMap<Class, ArrayList<Object>> tempRefreshMap = new HashMap<Class, ArrayList<Object>>();
        tempRefreshMap.putAll(this.refreshMap);
        this.refreshMap.clear();
        this.inner.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncDaoImpl.this.executeRefresh(tempRefreshMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void executeRefresh(Map<Class, ArrayList<Object>> tempMap) throws Exception {
        block0: for (Class clz : tempMap.keySet()) {
            ArrayList<Object> objList = tempMap.get(clz);
            String sql = MapperFactory.getSql(clz, "REFRESH");
            List<BeanElement> eles = MapperFactory.getElementList(clz);
            int size = objList.size();
            int times = size / MAX_BATCH + 1;
            for (int i = 0; i < times; ++i) {
                int segment = 0;
                if (i + 1 == times) {
                    segment = size % MAX_BATCH;
                    if (segment == 0) {
                        continue block0;
                    }
                } else {
                    segment = MAX_BATCH;
                }
                int fromIndex = i * MAX_BATCH;
                List<Object> subList = objList.subList(fromIndex, fromIndex + segment);
                this.batchRefresh(subList, sql, eles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchRefresh(List<Object> objList, String sql, List<BeanElement> eles) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(sql);
            Parsed parsed = Parser.get(objList.get(0).getClass());
            String keyOne = parsed.getKey(1);
            for (Object obj : objList) {
                int i = 1;
                for (BeanElement ele : eles) {
                    if (ele.property.equals(keyOne)) continue;
                    Method method = null;
                    try {
                        method = obj.getClass().getSuperclass().getDeclaredMethod(ele.getter, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        method = obj.getClass().getDeclaredMethod(ele.getter, new Class[0]);
                    }
                    Object value = method.invoke(obj, new Object[0]);
                    pstmt.setObject(i++, value);
                }
                SqlUtil.adpterSqlKey((PreparedStatement)pstmt, keyOne, obj, i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                pstmt.clearBatch();
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                conn.setAutoCommit(true);
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            AsyncDaoImpl.close(conn);
        }
    }

    @Deprecated
    public void tick(long now) {
        this.onHeartBeat(now);
    }

    private void onHeartBeat(final long now) {
        this.mainExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (AsyncDaoImpl.this.heartBeatTime == 0L) {
                    AsyncDaoImpl.this.heartBeatTime = now;
                    return;
                }
                if (now - AsyncDaoImpl.this.heartBeatTime >= 60000L) {
                    AsyncDaoImpl.this.heartBeatTime = now;
                    try {
                        AsyncDaoImpl.this.batch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void doImmediately() {
        this.mainExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncDaoImpl.this.batch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTryToCreate(Class clz) {
        String sql = MapperFactory.tryToCreate(clz);
        if (sql == null || sql.equals("")) {
            return;
        }
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(sql);
            pstmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            AsyncDaoImpl.close(conn);
        }
    }
}

