/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import x7.core.bean.BeanElement;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.CriteriaCondition;
import x7.core.bean.Parsed;
import x7.core.bean.Predicate;
import x7.core.bean.condition.RefreshCondition;
import x7.core.util.BeanUtil;
import x7.core.util.BeanUtilX;
import x7.core.util.StringUtil;
import x7.repository.CriteriaParser;
import x7.repository.DbType;

public class SqlUtil {
    protected static void adpterSqlKey(PreparedStatement pstmt, String keyOne, Object obj, int i) throws SQLException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = null;
        try {
            method = obj.getClass().getDeclaredMethod(BeanUtil.getGetter((String)keyOne), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = obj.getClass().getSuperclass().getDeclaredMethod(BeanUtil.getGetter((String)keyOne), new Class[0]);
        }
        Object value = method.invoke(obj, new Object[0]);
        pstmt.setObject(i++, value);
    }

    protected static void adpterSqlKey(PreparedStatement pstmt, Field keyOneF, Object obj, int i) throws SQLException, SecurityException, IllegalAccessException, IllegalArgumentException {
        Object value = keyOneF.get(obj);
        pstmt.setObject(i++, value);
    }

    protected static String concat(Parsed parsed, String sql, Map<String, Object> queryMap) {
        StringBuilder sb = new StringBuilder();
        boolean flag = sql.contains(" WHERE ") || sql.contains(" WHERE ".toLowerCase());
        for (String key : queryMap.keySet()) {
            String mapper = parsed.getMapper(key);
            if (flag) {
                sb.append(Conjunction.AND.sql()).append(mapper).append(" = ?");
                continue;
            }
            sb.append(" WHERE ").append(mapper).append(" = ?");
            flag = true;
        }
        sql = sql + sb.toString();
        return sql;
    }

    protected static String concatRefresh(StringBuilder sb, Parsed parsed, Map<String, Object> refreshMap) {
        String keyOne = parsed.getKey(1);
        refreshMap.remove(keyOne);
        sb.append(" SET ");
        int size = refreshMap.size();
        int i = 0;
        for (String key : refreshMap.keySet()) {
            BeanElement element = parsed.getElement(key);
            if (element.isJson && "oracle".equals(DbType.value)) {
                Object obj = refreshMap.get(key);
                StringReader reader = new StringReader(obj.toString());
                refreshMap.put(key, reader);
            }
            String mapper = parsed.getMapper(key);
            sb.append(mapper);
            sb.append(" = ?");
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(" WHERE ");
        String mapper = parsed.getMapper(keyOne);
        sb.append(mapper).append(" = ?");
        return sb.toString();
    }

    protected static String concatRefresh(StringBuilder sb, Parsed parsed, Map<String, Object> refreshMap, RefreshCondition refreshCondition, CriteriaParser criteriaParser) {
        String keyOne = parsed.getKey(1);
        Object keyOneValue = refreshMap.get(keyOne);
        refreshMap.remove(keyOne);
        if (Objects.nonNull(keyOneValue)) {
            String valueStr = keyOneValue.toString();
            if (StringUtil.isNullOrEmpty((String)valueStr)) {
                keyOneValue = null;
            } else {
                try {
                    long id = Long.valueOf(valueStr);
                    if (id == 0L) {
                        keyOneValue = null;
                    }
                }
                catch (Exception id) {
                    // empty catch block
                }
            }
        }
        sb.append(" SET ");
        List refreshList = refreshCondition.getRefreshList();
        int size = refreshList.size();
        int i = 0;
        for (Criteria.X x : refreshList) {
            if (x.getPredicate() == Predicate.X) {
                Object value = x.getValue();
                String str = value.toString();
                if (str.contains(",")) {
                    throw new RuntimeException("RefreshCondition.refresh(), para can not contains(,)");
                }
                String target = BeanUtilX.normalizeSql((String)str);
                target = BeanUtilX.mapper((String)target, (Parsed)parsed);
                sb.append(target);
                if (i < size + refreshMap.size() - 1) {
                    sb.append(",");
                }
            } else {
                refreshMap.put(x.getKey(), x.getValue());
            }
            ++i;
        }
        size = refreshMap.size();
        i = 0;
        for (String key : refreshMap.keySet()) {
            String mapper = parsed.getMapper(key);
            sb.append(mapper);
            sb.append(" = ?");
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        CriteriaCondition condition = refreshCondition.getCondition();
        List xList = condition.getListX();
        boolean flag = true;
        for (Criteria.X x : xList) {
            if (!x.getKey().equals(keyOne)) continue;
            flag = false;
            break;
        }
        if (flag && Objects.nonNull(keyOneValue)) {
            Criteria.X x = new Criteria.X();
            x.setConjunction(Conjunction.AND);
            x.setPredicate(Predicate.EQ);
            x.setKey(keyOne);
            x.setValue(keyOneValue);
            xList.add(0, x);
        }
        String conditionSql = criteriaParser.parseCondition(condition);
        conditionSql = BeanUtilX.mapper((String)conditionSql, (Parsed)parsed);
        sb.append(conditionSql);
        return sb.toString();
    }

    protected static void adpterRefreshCondition(PreparedStatement pstmt, int i, CriteriaCondition condition) throws SQLException, SecurityException, IllegalArgumentException {
        if (Objects.nonNull(condition)) {
            for (Object v : condition.getValueList()) {
                if (Objects.nonNull(v) && v.getClass().isEnum()) {
                    pstmt.setObject(i++, v.toString());
                    continue;
                }
                pstmt.setObject(i++, v);
            }
        }
    }
}

