/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.bean.Criteria;
import x7.core.bean.CriteriaBuilder;
import x7.core.bean.CriteriaCondition;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.condition.InCondition;
import x7.core.bean.condition.ReduceCondition;
import x7.core.bean.condition.RefreshCondition;
import x7.core.config.Configs;
import x7.core.repository.CacheResolver;
import x7.core.util.JsonX;
import x7.core.web.Direction;
import x7.core.web.Page;
import x7.repository.Repository;
import x7.repository.dao.Dao;
import x7.repository.exception.PersistenceException;

public class SqlRepository
implements Repository {
    private static final Logger logger = LoggerFactory.getLogger(SqlRepository.class);
    private static SqlRepository instance;
    private Dao syncDao;
    private CacheResolver cacheResolver;

    public static SqlRepository getInstance() {
        if (instance == null) {
            instance = new SqlRepository();
        }
        return instance;
    }

    public void setSyncDao(Dao syncDao) {
        logger.info("X7 Repository on starting....");
        this.syncDao = syncDao;
    }

    public void setCacheResolver(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    private boolean isNoCache() {
        return Configs.Inner.isDev || this.cacheResolver == null;
    }

    private String getCacheKey(Object obj, Parsed parsed) {
        try {
            Field field = obj.getClass().getDeclaredField(parsed.getKey(1));
            field.setAccessible(true);
            String keyOne = field.get(obj).toString();
            return keyOne;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> void replenishAndRefreshCache(List<String> keyList, List<T> list, Class<T> clz, Parsed parsed) {
        HashSet<String> keySet = new HashSet<String>();
        for (T t : list) {
            String key = this.getCacheKey(t, parsed);
            keySet.add(key);
        }
        for (String key : keyList) {
            if (keySet.contains(key)) continue;
            Object obj = null;
            Field f = parsed.getKeyField(1);
            if (f.getType() == String.class) {
                Object condition = null;
                try {
                    condition = clz.newInstance();
                    f.set(condition, key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                List tempList = null;
                tempList = this.syncDao.list((Object)condition);
                if (!tempList.isEmpty()) {
                    obj = tempList.get(0);
                }
            } else {
                long idOne = Long.valueOf(key);
                obj = this.syncDao.get(clz, idOne);
            }
            if (obj == null) {
                if (this.isNoCache() || parsed.isNoCache()) continue;
                this.cacheResolver.markForRefresh(clz);
                continue;
            }
            list.add(obj);
            if (this.isNoCache() || parsed.isNoCache()) continue;
            this.cacheResolver.set(clz, key, obj);
        }
    }

    private <T> List<T> sort(List<String> keyList, List<T> list, Parsed parsed) {
        ArrayList<T> sortedList = new ArrayList<T>();
        block0: for (String key : keyList) {
            Iterator<T> ite = list.iterator();
            while (ite.hasNext()) {
                T t = ite.next();
                if (!key.equals(this.getCacheKey(t, parsed))) continue;
                ite.remove();
                sortedList.add(t);
                continue block0;
            }
        }
        return sortedList;
    }

    @Override
    public long create(Object obj) {
        this.testAvailable();
        Class<?> clz = obj.getClass();
        Parsed parsed = Parser.get(clz);
        long id = this.syncDao.create(obj);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
        return id;
    }

    @Override
    public boolean refresh(Object obj) {
        this.testAvailable();
        boolean flag = false;
        Class<?> clz = obj.getClass();
        Parsed parsed = Parser.get(clz);
        flag = this.syncDao.refresh(obj);
        if (flag) {
            String key = this.getCacheKey(obj, parsed);
            if (!this.isNoCache() && !parsed.isNoCache()) {
                if (key != null) {
                    this.cacheResolver.remove(clz, key);
                }
                this.cacheResolver.markForRefresh(clz);
            }
        }
        return flag;
    }

    @Override
    public <T> boolean refresh(RefreshCondition<T> refreshCondition) {
        this.testAvailable();
        boolean flag = false;
        CriteriaCondition condition = refreshCondition.getCondition();
        Class clz = refreshCondition.getClz();
        if (condition instanceof Criteria) {
            Criteria criteria = (Criteria)condition;
            criteria.setClz(refreshCondition.getClz());
        }
        Parsed parsed = Parser.get((Class)clz);
        flag = this.syncDao.refreshByCondition(refreshCondition);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            Object obj = refreshCondition.getObj();
            if (Objects.isNull(obj)) {
                this.cacheResolver.remove(clz);
                this.cacheResolver.markForRefresh(clz);
            } else {
                String key = this.getCacheKey(obj, parsed);
                if (key != null) {
                    this.cacheResolver.remove(clz, key);
                }
                this.cacheResolver.markForRefresh(clz);
            }
        }
        return flag;
    }

    @Override
    public <T> void refreshCache(Class<T> clz) {
        Parsed parsed = Parser.get(clz);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
    }

    @Override
    public boolean remove(Object obj) {
        this.testAvailable();
        boolean flag = false;
        Class<?> clz = obj.getClass();
        Parsed parsed = Parser.get(clz);
        String key = this.getCacheKey(obj, parsed);
        flag = this.syncDao.remove(obj);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            if (key != null) {
                this.cacheResolver.remove(clz, key);
            }
            this.cacheResolver.markForRefresh(clz);
        }
        return flag;
    }

    @Override
    public <T> T get(Class<T> clz, long idOne) {
        this.testAvailable();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.get(clz, idOne);
        }
        String key = String.valueOf(idOne);
        Object obj = this.cacheResolver.get(clz, key);
        if (obj == null) {
            obj = this.syncDao.get(clz, idOne);
            this.cacheResolver.set(clz, key, obj);
        }
        return (T)obj;
    }

    @Override
    public <T> List<T> list(Object conditionObj) {
        this.testAvailable();
        if (conditionObj instanceof CriteriaBuilder || conditionObj instanceof Criteria) {
            throw new RuntimeException("Notes: parameter is not Criteria");
        }
        Class<?> clz = conditionObj.getClass();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.list(conditionObj);
        }
        List list = null;
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, conditionObj);
        if (keyList == null || keyList.isEmpty()) {
            list = this.syncDao.list(conditionObj);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, conditionObj, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public <T> T getOne(T conditionObj) {
        this.testAvailable();
        Class<?> clz = conditionObj.getClass();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            T t = this.syncDao.getOne(conditionObj);
            return t;
        }
        String condition = JsonX.toJson(conditionObj);
        Object obj = this.cacheResolver.get(clz, condition);
        if (obj == null) {
            obj = this.syncDao.getOne(conditionObj);
            this.cacheResolver.set(clz, condition, obj);
            return (T)obj;
        }
        return (T)obj;
    }

    @Override
    public <T> T getOne(T conditionObj, String orderBy, Direction sc) {
        this.testAvailable();
        Class<?> clz = conditionObj.getClass();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.getOne(conditionObj, orderBy, sc);
        }
        String condition = JsonX.toJson(conditionObj) + orderBy + sc;
        Object obj = this.cacheResolver.get(clz, condition);
        if (obj == null) {
            T t = this.syncDao.getOne(conditionObj, orderBy, sc);
            this.cacheResolver.set(clz, condition, obj);
            return t;
        }
        return (T)obj;
    }

    @Override
    public <T> Page<T> find(Criteria criteria) {
        this.testAvailable();
        Class clz = criteria.getClz();
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache()) {
            return this.syncDao.find(criteria);
        }
        List list = null;
        Page p = this.cacheResolver.getResultKeyListPaginated(clz, (Object)criteria);
        if (p == null) {
            this.syncDao.find(criteria);
            list = p.getList();
            List keyList = p.getKeyList();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            p.reSetList(null);
            this.cacheResolver.setResultKeyListPaginated(clz, (Object)criteria, p);
            p.setKeyList(null);
            p.reSetList(list);
            return p;
        }
        List keyList = p.getKeyList();
        if (keyList == null || keyList.isEmpty()) {
            return p;
        }
        list = this.cacheResolver.list(clz, keyList);
        if (keyList.size() == list.size()) {
            p.reSetList(list);
            return p;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        p.reSetList(sortedList);
        return p;
    }

    @Override
    public <T> List<T> list(Criteria criteria) {
        this.testAvailable();
        Class clz = criteria.getClz();
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache()) {
            return this.syncDao.list(criteria);
        }
        List list = null;
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, (Object)criteria);
        if (keyList == null || keyList.isEmpty()) {
            list = this.syncDao.list(criteria);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, (Object)criteria, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public <T> List<T> list(Class<T> clz) {
        this.testAvailable();
        Parsed parsed = Parser.get(clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.list(clz);
        }
        List list = null;
        String condition = "loadAll";
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, (Object)condition);
        if (keyList == null || keyList.isEmpty()) {
            list = this.syncDao.list(clz);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, (Object)condition, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public Object reduce(ReduceCondition reduceCondition) {
        this.testAvailable();
        return this.syncDao.reduce(reduceCondition);
    }

    protected <T> boolean execute(T obj, String sql) {
        this.testAvailable();
        Parsed parsed = Parser.get(obj.getClass());
        boolean b = this.syncDao.execute(obj, sql);
        if (b) {
            String key = this.getCacheKey(obj, parsed);
            if (!this.isNoCache() && !parsed.isNoCache() && key != null) {
                this.cacheResolver.remove(obj.getClass(), key);
            }
        }
        return b;
    }

    @Override
    public <T> List<T> in(InCondition inCondition) {
        this.testAvailable();
        Class clz = inCondition.getClz();
        String inProperty = inCondition.getProperty();
        Parsed parsed = Parser.get((Class)clz);
        List inList = inCondition.getInList();
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.in(inCondition);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(inProperty).append(":");
        for (Object obj : inList) {
            sb.append(obj.toString()).append("_");
        }
        String condition = sb.toString();
        ArrayList<String> keyList = this.cacheResolver.getResultKeyList(clz, (Object)condition);
        List list = null;
        if (keyList == null || keyList.isEmpty()) {
            list = this.syncDao.in(inCondition);
            keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = this.getCacheKey(t, parsed);
                keyList.add(key);
            }
            this.cacheResolver.setResultKeyList(clz, (Object)condition, keyList);
            return list;
        }
        list = this.cacheResolver.list(clz, (List)keyList);
        if (keyList.size() == list.size()) {
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed);
        List<T> sortedList = this.sort(keyList, list, parsed);
        return sortedList;
    }

    @Override
    public Page<Map<String, Object>> find(Criteria.ResultMappedCriteria resultMapped) {
        this.testAvailable();
        return this.syncDao.find(resultMapped);
    }

    @Override
    public List<Map<String, Object>> list(Criteria.ResultMappedCriteria resultMapped) {
        this.testAvailable();
        return this.syncDao.list(resultMapped);
    }

    @Override
    public boolean createBatch(List<? extends Object> objList) {
        this.testAvailable();
        if (objList.isEmpty()) {
            return false;
        }
        Class<?> clz = objList.get(0).getClass();
        Parsed parsed = Parser.get(clz);
        boolean flag = this.syncDao.createBatch(objList);
        if (!this.isNoCache() && !parsed.isNoCache()) {
            this.cacheResolver.markForRefresh(clz);
        }
        return flag;
    }

    protected List<Map<String, Object>> list(Class clz, String sql, List<Object> conditionList) {
        Parsed parsed = Parser.get((Class)clz);
        if (this.isNoCache() || parsed.isNoCache()) {
            return this.syncDao.list(clz, sql, conditionList);
        }
        String condition = sql + conditionList.toString();
        List<Map<String, Object>> mapList = this.cacheResolver.getMapList(clz, condition);
        if (mapList == null && (mapList = this.syncDao.list(clz, sql, conditionList)) != null) {
            this.cacheResolver.setMapList(clz, condition, mapList);
        }
        return mapList;
    }

    private void testAvailable() {
        if (Objects.isNull(this.syncDao)) {
            throw new PersistenceException("X7-Repository does not started");
        }
    }
}

