/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.exception.CacheException;
import x7.core.repository.CacheResolver;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.core.util.VerifyUtil;
import x7.core.web.Page;
import x7.repository.exception.PersistenceException;
import x7.repository.redis.JedisConnector_Cache;
import x7.repository.redis.ObjectUtil;

public class LevelTwoCacheResolver
implements CacheResolver {
    private static final Logger logger = LoggerFactory.getLogger(LevelTwoCacheResolver.class);
    public static final String NANO_SECOND = ".ns.";
    private static LevelTwoCacheResolver instance = null;
    private int validSecond;

    public static LevelTwoCacheResolver getInstance() {
        if (instance == null) {
            instance = new LevelTwoCacheResolver();
        }
        return instance;
    }

    public void setValidSecond(int validSecond) {
        this.validSecond = validSecond;
        System.out.println("\n");
        logger.info("L2 Cache try to starting.... cache time = " + validSecond + "s");
        System.out.println("\n");
    }

    private int getValidSecondAdjusted() {
        return this.validSecond;
    }

    public String markForRefresh(Class clz) {
        String key = this.getNSKey(clz);
        String time = String.valueOf(System.nanoTime());
        boolean flag = JedisConnector_Cache.getInstance().set(key, time);
        if (!flag) {
            throw new CacheException("markForRefresh failed");
        }
        return time;
    }

    public void remove(Class clz, String key) {
        key = this.getSimpleKey(clz, key);
        boolean flag = JedisConnector_Cache.getInstance().delete(key);
        if (!flag) {
            throw new CacheException("remove failed");
        }
    }

    public void remove(Class clz) {
        String key = this.getSimpleKeyLike(clz);
        Set<String> keySet = JedisConnector_Cache.getInstance().keys(key);
        for (String k : keySet) {
            boolean flag = JedisConnector_Cache.getInstance().delete(k);
            if (flag) continue;
            throw new CacheException("remove failed");
        }
    }

    private String getNSKey(Class clz) {
        return clz.getName() + NANO_SECOND;
    }

    private String getNS(String nsKey) {
        return JedisConnector_Cache.getInstance().get(nsKey);
    }

    private List<String> getKeyList(Class clz, List<String> conditionList) {
        if (conditionList == null || conditionList.isEmpty()) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String condition : conditionList) {
            String key = this.getSimpleKey(clz, condition);
            keyList.add(key);
        }
        if (keyList.isEmpty()) {
            return null;
        }
        return keyList;
    }

    private String getSimpleKey(Class clz, String condition) {
        return "{" + clz.getName() + "}." + condition;
    }

    private String getSimpleKeyLike(Class clz) {
        return "{" + clz.getName() + "}.*";
    }

    private String getKey(Class clz, Object conditionObj) {
        String condition = JsonX.toJson((Object)conditionObj);
        long startTime = System.currentTimeMillis();
        String key = this.getPrefix(clz) + "." + VerifyUtil.toMD5((String)condition);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("LevelTwoCacheResolver.getKey() cost time = " + (endTime - startTime) + "s");
        }
        return key;
    }

    private String getPrefix(Class clz) {
        String key = this.getNSKey(clz);
        String nsStr = JedisConnector_Cache.getInstance().get(key);
        if (nsStr == null) {
            String str = this.markForRefresh(clz);
            return "{" + clz.getName() + "}." + str;
        }
        return "{" + clz.getName() + "}." + nsStr;
    }

    public void set(Class clz, String key, Object obj) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        JedisConnector_Cache.getInstance().set(key, JsonX.toJson((Object)obj), validSecond);
    }

    public void setResultKeyList(Class clz, Object condition, List<String> keyList) {
        String key = this.getKey(clz, condition);
        try {
            JedisConnector_Cache.getInstance().set(key, JsonX.toJson(keyList), this.validSecond);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public <T> void setResultKeyListPaginated(Class<T> clz, Object condition, Page<T> pagination) {
        String key = this.getKey(clz, condition);
        try {
            JedisConnector_Cache.getInstance().set(key, JsonX.toJson(pagination), this.validSecond);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public List<String> getResultKeyList(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        String str = JedisConnector_Cache.getInstance().get(key);
        if (StringUtil.isNullOrEmpty((String)str)) {
            return new ArrayList<String>();
        }
        return JsonX.toList((String)str, String.class);
    }

    public Page<String> getResultKeyListPaginated(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        String json = JedisConnector_Cache.getInstance().get(key);
        if (StringUtil.isNullOrEmpty((String)json)) {
            return null;
        }
        return ObjectUtil.toPagination(json);
    }

    public <T> List<T> list(Class<T> clz, List<String> keyList) {
        List<String> keyArr = this.getKeyList(clz, keyList);
        List<String> jsonList = JedisConnector_Cache.getInstance().mget(keyArr);
        if (jsonList == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String json : jsonList) {
            if (!StringUtil.isNotNull((String)json)) continue;
            Object t = JsonX.toObject((String)json, clz);
            list.add(t);
        }
        return list;
    }

    public <T> T get(Class<T> clz, String key) {
        key = this.getSimpleKey(clz, key);
        String str = JedisConnector_Cache.getInstance().get(key);
        if (StringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        Object obj = JsonX.toObject((String)str, clz);
        return (T)obj;
    }

    public void setMapList(Class clz, String key, List<Map<String, Object>> mapList) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        JedisConnector_Cache.getInstance().set(key, JsonX.toJson(mapList), validSecond);
    }

    public List<Map<String, Object>> getMapList(Class clz, String key) {
        key = this.getSimpleKey(clz, key);
        String str = JedisConnector_Cache.getInstance().get(key);
        if (StringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        List mapList = JsonX.toList((String)str, Map.class);
        return mapList;
    }
}

