/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dialect;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.sql.NCLOB;
import x7.core.bean.BeanElement;
import x7.core.bean.Criteria;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.util.JsonX;
import x7.core.util.StringUtil;
import x7.repository.mapper.Mapper;

public class OracleDialect
implements Mapper.Dialect {
    private final String ALIA_NAME = "AAA";
    private Map<String, String> map = new HashMap<String, String>(){
        {
            this.put(" ${DATE}", "date");
            this.put(" ${BYTE}", "number(3, 0)");
            this.put(" ${INT}", "number(10, 0)");
            this.put(" ${LONG}", "number(18, 0)");
            this.put(" ${BIG}", "number(19, 2)");
            this.put(" ${STRING}", "varchar2");
            this.put(" ${TEXT}", "clob");
            this.put(" ${LONG_TEXT}", "clob");
            this.put(" ${INCREAMENT}", "");
            this.put(" ${ENGINE}", "");
        }
    };
    private static final String ORACLE_PAGINATION = "SELECT * FROM (SELECT A.*, ROWNUM RN FROM ( ${SQL} ) A   WHERE ROWNUM <= ${END}  )  WHERE RN > ${BEGIN} ";
    private static final String ORACLE_PAGINATION_REGX_SQL = "${SQL}";
    private static final String ORACLE_PAGINATION_REGX_BEGIN = "${BEGIN}";
    private static final String ORACLE_PAGINATION_REGX_END = "${END}";

    @Override
    public String match(String sql, long start, long rows) {
        if (rows > 0L) {
            return ORACLE_PAGINATION.replace(ORACLE_PAGINATION_REGX_END, String.valueOf(start + rows)).replace(ORACLE_PAGINATION_REGX_BEGIN, String.valueOf(start)).replace(ORACLE_PAGINATION_REGX_SQL, sql);
        }
        return sql;
    }

    @Override
    public String match(String sql, String sqlType) {
        String dateV = this.map.get(" ${DATE}");
        String byteV = this.map.get(" ${BYTE}");
        String intV = this.map.get(" ${INT}");
        String longV = this.map.get(" ${LONG}");
        String bigV = this.map.get(" ${BIG}");
        String textV = this.map.get(" ${TEXT}");
        String longTextV = this.map.get(" ${LONG_TEXT}");
        String stringV = this.map.get(" ${STRING}");
        String increamentV = this.map.get(" ${INCREAMENT}");
        String engineV = this.map.get(" ${ENGINE}");
        return sql.replace(" ${DATE}".trim(), dateV).replace(" ${BYTE}".trim(), byteV).replace(" ${INT}".trim(), intV).replace(" ${LONG}".trim(), longV).replace(" ${BIG}".trim(), bigV).replace(" ${TEXT}".trim(), textV).replace(" ${LONG_TEXT}".trim(), longTextV).replace(" ${STRING}".trim(), stringV).replace(" ${INCREAMENT}".trim(), increamentV).replace(" ${ENGINE}".trim(), engineV);
    }

    private Object getObject(String mapper, ResultSet rs, BeanElement element) throws SQLException, IOException {
        Object obj = null;
        Class ec = element.clz;
        if (element.isJson) {
            obj = rs.getObject(mapper);
            if (Objects.isNull(obj)) {
                return null;
            }
            String str = null;
            if (obj instanceof String) {
                str = obj.toString();
            } else if (obj instanceof NCLOB) {
                NCLOB clob = (NCLOB)obj;
                Reader reader = clob.getCharacterStream();
                char[] charArr = new char[(int)clob.length()];
                reader.read(charArr);
                reader.close();
                str = new String(charArr);
            }
            if (StringUtil.isNullOrEmpty((String)str)) {
                return null;
            }
            if (!(str = str.trim()).startsWith("{") && !str.startsWith("[")) {
                return str;
            }
            if (ec == List.class) {
                Class geneType = element.geneType;
                return JsonX.toList((String)str, (Class)geneType);
            }
            if (ec == Map.class) {
                return JsonX.toMap((String)str);
            }
            return JsonX.toObject((String)str, (Class)ec);
        }
        obj = rs.getObject(mapper);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bg = (BigDecimal)obj;
            if (ec == BigDecimal.class) {
                return bg;
            }
            if (ec == Integer.TYPE || ec == Integer.class) {
                return bg.intValue();
            }
            if (ec == Long.TYPE || ec == Long.class) {
                return bg.longValue();
            }
            if (ec == Double.TYPE || ec == Double.class) {
                return bg.doubleValue();
            }
            if (ec == Float.TYPE || ec == Float.class) {
                return Float.valueOf(bg.floatValue());
            }
            if (ec == Boolean.TYPE || ec == Boolean.class) {
                int i = bg.intValue();
                return i != 0;
            }
            if (ec == java.util.Date.class) {
                long l = bg.longValue();
                return new java.util.Date(l);
            }
            if (ec == Date.class) {
                long l = bg.longValue();
                return new Date(l);
            }
            if (ec == Timestamp.class) {
                long l = bg.longValue();
                return new Timestamp(l);
            }
            if (ec == Byte.TYPE || ec == Byte.class) {
                return bg.byteValue();
            }
        } else if (obj instanceof Timestamp && ec == java.util.Date.class) {
            Timestamp ts = (Timestamp)obj;
            return new java.util.Date(ts.getTime());
        }
        if (ec.isEnum()) {
            return Enum.valueOf(ec, obj.toString());
        }
        return obj;
    }

    @Override
    public Object mappedResult(String property, String mapper, Map<String, String> aliaMap, ResultSet rs) throws SQLException, IOException {
        if (mapper == null) {
            throw new RuntimeException("Result key is empty?");
        }
        if (property.contains(".")) {
            String m;
            String[] arr = property.split("\\.");
            String clzName = arr[0];
            String p = arr[1];
            Parsed parsed = Parser.get((String)clzName);
            BeanElement element = parsed.getElement(p);
            if (mapper.contains("`")) {
                mapper = mapper.replace("`", "");
            }
            String string = mapper = (m = aliaMap.get(mapper)) == null ? mapper : m;
            if (element == null) {
                return rs.getObject(mapper);
            }
            return this.getObject(mapper, rs, element);
        }
        if (mapper.contains("`")) {
            mapper = mapper.replace("`", "");
        }
        return rs.getObject(mapper);
    }

    @Override
    public <T> void initObj(T obj, ResultSet rs, BeanElement tempEle, List<BeanElement> eles) throws IOException, SQLException, InvocationTargetException, IllegalAccessException {
        for (BeanElement ele : eles) {
            Method method = ele.setMethod;
            String mapper = ele.getMapper();
            Object value = this.getObject(mapper, rs, ele);
            if (value == null) continue;
            method.invoke(obj, value);
        }
    }

    @Override
    public String filterResultKey(String mapper, Criteria.ResultMappedCriteria criteria) {
        Map aliaMap = criteria.getAliaMap();
        String alian = "AAA" + aliaMap.size();
        aliaMap.put(mapper, alian);
        String target = mapper + " AS " + alian;
        return target;
    }

    @Override
    public void setJSON(int i, String str, PreparedStatement pstmt) throws SQLException, IOException {
        pstmt.setObject(i, str);
    }

    @Override
    public void setObject(int i, Object obj, PreparedStatement pstm) throws SQLException {
        if (obj instanceof Reader) {
            Reader reader = (Reader)obj;
            pstm.setNClob(i, reader);
        } else {
            pstm.setObject(i, obj);
        }
    }

    @Override
    public Object filterValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            value = str.replace("<", "&lt").replace(">", "&gt");
        } else {
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return b == true ? 1 : 0;
            }
        }
        return value;
    }
}

