/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import x7.core.async.CasualWorker;
import x7.core.async.IAsyncTask;
import x7.core.config.Configs;
import x7.repository.DataSourceSetter;
import x7.repository.DbType;
import x7.repository.HealthChecker;
import x7.repository.IdGenerator;
import x7.repository.SqlRepository;
import x7.repository.dao.DaoImpl;
import x7.repository.mapper.Mapper;
import x7.repository.mapper.MapperFactory;
import x7.repository.redis.JedisConnector_Persistence;
import x7.repository.util.ResultSetUtil;

public class RepositoryBooter {
    private static RepositoryBooter instance = null;

    public static void boot() {
        if (instance == null) {
            instance = new RepositoryBooter();
            RepositoryBooter.init();
            HealthChecker.onStarted();
            CasualWorker.accept((IAsyncTask)new IAsyncTask(){

                public void execute() throws Exception {
                    try {
                        Thread.sleep(3000L);
                        RepositoryBooter.generateId();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void boot(DataSource ds_W, DataSource ds_R) {
        if (instance == null) {
            instance = new RepositoryBooter();
            RepositoryBooter.setDataSource(ds_W, ds_R);
            HealthChecker.onStarted();
            CasualWorker.accept((IAsyncTask)new IAsyncTask(){

                public void execute() throws Exception {
                    try {
                        Thread.sleep(1000L);
                        RepositoryBooter.generateId();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void generateId() {
        System.out.println("\n----------------------------------------");
        List<IdGenerator> idGeneratorList = SqlRepository.getInstance().list(IdGenerator.class);
        for (IdGenerator generator : idGeneratorList) {
            String name = generator.getClzName();
            long maxId = generator.getMaxId();
            String idInRedis = JedisConnector_Persistence.getInstance().hget("ID_MAP_KEY", name);
            System.out.println(name + ",test, idInDB = " + maxId + ", idInRedis = " + idInRedis);
            if (idInRedis == null) {
                JedisConnector_Persistence.getInstance().hset("ID_MAP_KEY", name, String.valueOf(maxId));
            } else if (idInRedis != null && maxId > Long.valueOf(idInRedis)) {
                JedisConnector_Persistence.getInstance().hset("ID_MAP_KEY", name, String.valueOf(maxId));
            }
            System.out.println(name + ",final, idInRedis = " + JedisConnector_Persistence.getInstance().hget("ID_MAP_KEY", name));
        }
        System.out.println("----------------------------------------\n");
    }

    private static void init() {
        RepositoryBooter.onDriver(null);
        RepositoryBooter.setDataSource(null, null);
    }

    public static void onDriver(String driverClassName) {
        String driver = null;
        driver = Objects.isNull(driverClassName) ? Configs.getString((String)"x7.db.driver") : driverClassName;
        driver = driver.toLowerCase();
        try {
            Mapper.Dialect dialect = null;
            if (driver.contains("mysql")) {
                DbType.value = "mysql";
                dialect = (Mapper.Dialect)Class.forName("x7.repository.dialect.MySqlDialect").newInstance();
                RepositoryBooter.initDialect(dialect);
            } else if (driver.contains("oracle")) {
                DbType.value = "oracle";
                dialect = (Mapper.Dialect)Class.forName("x7.repository.dialect.OracleDialect").newInstance();
                RepositoryBooter.initDialect(dialect);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setDataSource(DataSource ds_W, DataSource ds_R) {
        if (Objects.isNull(ds_W)) {
            throw new RuntimeException("Primary DataSource start failed");
        }
        DataSourceSetter.set(ds_W, ds_R);
        SqlRepository.getInstance().setSyncDao(DaoImpl.getInstance());
    }

    private static void initDialect(Mapper.Dialect dialect) {
        MapperFactory.Dialect = dialect;
        DaoImpl.getInstance().setDialect(dialect);
        ResultSetUtil.dialect = dialect;
    }
}

