/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.util.StringUtil;
import x7.repository.BaseRepository;
import x7.repository.DbType;
import x7.repository.IdGenerator;
import x7.repository.ManuRepository;
import x7.repository.SqlRepository;
import x7.repository.mapper.MapperFactory;

public class HealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(HealthChecker.class);
    private static List<BaseRepository> repositoryList = new ArrayList<BaseRepository>();

    public static List<BaseRepository> getRepositoryList() {
        return repositoryList;
    }

    public static void onStarted() {
        for (BaseRepository repository : repositoryList) {
            logger.info("Parsing " + repository.getClz());
            Parser.get(repository.getClz());
        }
        String sql = "CREATE TABLE IF NOT EXISTS `idGenerator` ( `clzName` varchar(120) NOT NULL, `maxId` bigint(13) DEFAULT NULL, PRIMARY KEY (`clzName`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
        try {
            ManuRepository.execute(new IdGenerator(), sql);
        }
        catch (Exception repository) {
            // empty catch block
        }
        System.out.println("-------------------------------------------------");
        boolean flag = false;
        for (BaseRepository repository : repositoryList) {
            try {
                Parsed clzParsed;
                Field f;
                Class clz = repository.getClz();
                String createSql = MapperFactory.tryToCreate(clz);
                String test = MapperFactory.getSql(clz, "CREATE");
                if (StringUtil.isNullOrEmpty((String)test)) {
                    logger.info("FAILED TO START X7-REPOSITORY, check Bean: " + clz);
                    System.exit(1);
                }
                if (DbType.value.equals("mysql")) {
                    ManuRepository.execute(clz.newInstance(), createSql);
                }
                if ((f = (clzParsed = Parser.get(clz)).getKeyField(1)).getType() == String.class) continue;
                String name = clz.getName();
                IdGenerator generator = new IdGenerator();
                generator.setClzName(name);
                List list = SqlRepository.getInstance().list(generator);
                if (!list.isEmpty()) continue;
                logger.info("id init: " + generator.getClzName());
                generator.setMaxId(0L);
                SqlRepository.getInstance().create(generator);
            }
            catch (Exception e) {
                flag |= true;
            }
        }
        logger.info("X7 Repository " + (flag ? "still " : "") + "started" + (flag ? " OK, wtih some problem" : ""));
    }
}

