/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import x7.core.bean.BeanElement;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.util.BeanUtil;
import x7.core.util.BeanUtilX;
import x7.repository.DbType;
import x7.repository.mapper.Mapper;

public class MapperFactory
implements Mapper {
    private static Map<Class, Map<String, String>> sqlsMap = new HashMap<Class, Map<String, String>>();
    public static Mapper.Dialect Dialect;

    public static String getSql(Class clz, String type) {
        Map<String, String> sqlMap = sqlsMap.get(clz);
        if (sqlMap == null) {
            sqlMap = new HashMap<String, String>();
            sqlsMap.put(clz, sqlMap);
            MapperFactory.parseBean(clz);
        }
        return sqlMap.get(type);
    }

    public static String tryToCreate(Class clz) {
        Map<String, String> sqlMap = sqlsMap.get(clz);
        if (sqlMap == null) {
            sqlMap = new HashMap<String, String>();
            sqlsMap.put(clz, sqlMap);
            MapperFactory.parseBean(clz);
            return sqlMap.remove("CREATE_TABLE");
        }
        return "";
    }

    public static List<BeanElement> getElementList(Class clz) {
        return Parser.get((Class)clz).getBeanElementList();
    }

    public static void parseBean(Class clz) {
        String dbType;
        switch (dbType = DbType.value) {
            default: 
        }
        StandardSql sql = new StandardSql();
        sql.getTableSql(clz);
        sql.getRefreshSql(clz);
        sql.getRemoveSql(clz);
        sql.getQuerySql(clz);
        sql.getLoadSql(clz);
        sql.getCreateSql(clz);
        sql.getTagSql(clz);
    }

    public static String getTableName(Class clz) {
        Parsed parsed = Parser.get((Class)clz);
        return parsed.getTableName();
    }

    public static class StandardSql
    implements Mapper.Interpreter {
        @Override
        public String getRefreshSql(Class clz) {
            String column;
            Parsed parsed = Parser.get((Class)clz);
            List list = Parser.get((Class)clz).getBeanElementList();
            String space = " ";
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(space);
            sb.append("SET ");
            String keyOne = parsed.getKey(1);
            ArrayList<BeanElement> tempList = new ArrayList<BeanElement>();
            for (BeanElement p : list) {
                column = p.property;
                if (column.equals(keyOne)) continue;
                tempList.add(p);
            }
            int size = tempList.size();
            for (int i = 0; i < size; ++i) {
                column = ((BeanElement)tempList.get((int)i)).property;
                sb.append(column).append(" = ?");
                if (i >= size - 1) continue;
                sb.append(", ");
            }
            sb.append(" WHERE ");
            this.parseKey(sb, clz);
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("REFRESH", sql);
            System.out.println(sql);
            return sql;
        }

        public String getRemoveSql(Class clz) {
            Parsed parsed = Parser.get((Class)clz);
            String space = " ";
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(space);
            sb.append("WHERE ");
            this.parseKey(sb, clz);
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("REMOVE", sql);
            System.out.println(sql);
            return sql;
        }

        public void parseKey(StringBuilder sb, Class clz) {
            Parsed parsed = Parser.get((Class)clz);
            sb.append(parsed.getKey(1));
            sb.append(" = ?");
        }

        @Override
        public String getQuerySql(Class clz) {
            Parsed parsed = Parser.get((Class)clz);
            String space = " ";
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(space);
            sb.append("WHERE ");
            sb.append(parsed.getKey(1));
            sb.append(" = ?");
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("QUERY", sql);
            System.out.println(sql);
            return sql;
        }

        @Override
        public String getLoadSql(Class clz) {
            Parsed parsed = Parser.get((Class)clz);
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName()));
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("LOAD", sql);
            System.out.println(sql);
            return sql;
        }

        @Override
        public String getCreateSql(Class clz) {
            int i;
            List list = Parser.get((Class)clz).getBeanElementList();
            Parsed parsed = Parser.get((Class)clz);
            ArrayList<BeanElement> tempList = new ArrayList<BeanElement>();
            for (BeanElement p : list) {
                tempList.add(p);
            }
            String space = " ";
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(space);
            sb.append("(");
            int size = tempList.size();
            for (i = 0; i < size; ++i) {
                String p = ((BeanElement)tempList.get((int)i)).property;
                sb.append(" ").append(p).append(" ");
                if (i >= size - 1) continue;
                sb.append(",");
            }
            sb.append(") VALUES (");
            for (i = 0; i < size; ++i) {
                sb.append("?");
                if (i >= size - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("CREATE", sql);
            System.out.println(sql);
            return sql;
        }

        @Override
        public String getTableSql(Class clz) {
            String dbType = DbType.value;
            List temp = Parser.get((Class)clz).getBeanElementList();
            HashMap<String, BeanElement> map = new HashMap<String, BeanElement>();
            ArrayList<BeanElement> list = new ArrayList<BeanElement>();
            for (BeanElement be : temp) {
                if (be.sqlType != null && be.sqlType.equals("text")) {
                    list.add(be);
                    continue;
                }
                map.put(be.property, be);
            }
            Parsed parsed = Parser.get((Class)clz);
            String keyOne = parsed.getKey(1);
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE IF NOT EXISTS ").append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(" (").append("\n");
            sb.append("   ").append(keyOne);
            BeanElement be = (BeanElement)map.get(keyOne);
            String sqlType = Mapper.getSqlTypeRegX(be);
            System.out.println("p = " + be.property + " sqlType = " + sqlType);
            if (sqlType.equals(" ${INT}")) {
                sb.append(" ${INT}" + " NOT NULL");
            } else if (sqlType.equals(" ${LONG}")) {
                sb.append(" ${LONG}" + " NOT NULL");
            } else if (sqlType.equals(" ${STRING}")) {
                sb.append(" ${STRING}").append("(").append(be.length).append(") NOT NULL");
            }
            sb.append(", ");
            sb.append("\n");
            map.remove(keyOne);
            for (BeanElement bet : map.values()) {
                sqlType = Mapper.getSqlTypeRegX(bet);
                sb.append("   ").append(bet.property).append(" ");
                sb.append(sqlType);
                if (sqlType.equals(" ${BIG}")) {
                    sb.append(" DEFAULT 0.00 ");
                } else if (sqlType.equals(" ${DATE}")) {
                    sb.append(" NULL");
                } else if (bet.clz.isEnum()) {
                    sb.append("(").append(bet.length).append(") NOT NULL");
                } else if (sqlType.equals(" ${STRING}")) {
                    sb.append("(").append(bet.length).append(") NULL");
                } else if (bet.clz == Boolean.class || bet.clz == Boolean.TYPE || bet.clz == Integer.class || bet.clz == Integer.TYPE || bet.clz == Long.class || bet.clz == Long.TYPE) {
                    sb.append(" DEFAULT 0");
                } else {
                    sb.append(" DEFAULT NULL");
                }
                sb.append(",").append("\n");
            }
            for (BeanElement bet : list) {
                sqlType = Mapper.getSqlTypeRegX(bet);
                sb.append("   ").append(bet.property).append(" ").append(sqlType).append(",").append("\n");
            }
            sb.append("   PRIMARY KEY ( ").append(keyOne).append(" )");
            sb.append("\n");
            sb.append(") ").append(" ${ENGINE}").append(";");
            String sql = sb.toString();
            sql = Dialect.match(sql, "CREATE_TABLE");
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            System.out.println(sql);
            ((Map)sqlsMap.get(clz)).put("CREATE_TABLE", sql);
            return sql;
        }

        @Override
        public String getTagSql(Class clz) {
            Parsed parsed = Parser.get((Class)clz);
            String space = " ";
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ${TAG} FROM ");
            sb.append(BeanUtil.getByFirstLower((String)parsed.getClzName())).append(space);
            String sql = sb.toString();
            sql = BeanUtilX.mapper((String)sql, (Parsed)parsed);
            ((Map)sqlsMap.get(clz)).put("TAG", sql);
            System.out.println(sql);
            return sql;
        }
    }
}

