/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dialect;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import x7.core.bean.BeanElement;
import x7.core.bean.Criteria;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.util.JsonX;
import x7.repository.mapper.Mapper;

public class MySqlDialect
implements Mapper.Dialect {
    private Map<String, String> map = new HashMap<String, String>(){
        {
            this.put(" ${DATE}", "timestamp");
            this.put(" ${BYTE}", "tinyint(1)");
            this.put(" ${INT}", "int(11)");
            this.put(" ${LONG}", "bigint(13)");
            this.put(" ${BIG}", "decimal(15,2)");
            this.put(" ${STRING}", "varchar");
            this.put(" ${TEXT}", "text");
            this.put(" ${LONG_TEXT}", "longtext");
            this.put(" ${INCREAMENT}", "AUTO_INCREMENT");
            this.put(" ${ENGINE}", "ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }
    };

    @Override
    public String match(String sql, long start, long rows) {
        if (rows == 0L) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        sb.append(" LIMIT ").append(start).append(",").append(rows);
        return sb.toString();
    }

    @Override
    public String match(String sql, String sqlType) {
        String dateV = this.map.get(" ${DATE}");
        String byteV = this.map.get(" ${BYTE}");
        String intV = this.map.get(" ${INT}");
        String longV = this.map.get(" ${LONG}");
        String bigV = this.map.get(" ${BIG}");
        String textV = this.map.get(" ${TEXT}");
        String longTextV = this.map.get(" ${LONG_TEXT}");
        String stringV = this.map.get(" ${STRING}");
        String increamentV = this.map.get(" ${INCREAMENT}");
        String engineV = this.map.get(" ${ENGINE}");
        return sql.replace(" ${DATE}".trim(), dateV).replace(" ${BYTE}".trim(), byteV).replace(" ${INT}".trim(), intV).replace(" ${LONG}".trim(), longV).replace(" ${BIG}".trim(), bigV).replace(" ${TEXT}".trim(), textV).replace(" ${LONG_TEXT}".trim(), longTextV).replace(" ${STRING}".trim(), stringV).replace(" ${INCREAMENT}".trim(), increamentV).replace(" ${ENGINE}".trim(), engineV);
    }

    private Object getObject(String mapper, ResultSet rs, BeanElement element) throws SQLException, IOException {
        Class ec = element.clz;
        Object obj = rs.getObject(mapper);
        if (obj == null) {
            return null;
        }
        if (ec.isEnum()) {
            return Enum.valueOf(ec, obj.toString());
        }
        if (element.isJson) {
            if (ec == List.class) {
                Class geneType = element.geneType;
                return JsonX.toList((String)obj.toString(), (Class)geneType);
            }
            if (ec == Map.class) {
                return JsonX.toMap((Object)obj);
            }
            return JsonX.toObject((String)obj.toString(), (Class)ec);
        }
        if (ec == BigDecimal.class) {
            return new BigDecimal(String.valueOf(obj));
        }
        if (ec == Double.TYPE || ec == Double.class) {
            return Double.valueOf(obj.toString());
        }
        return obj;
    }

    @Override
    public Object mappedResult(String property, String mapper, Map<String, String> aliaMap, ResultSet rs) throws SQLException, IOException {
        if (mapper == null) {
            throw new RuntimeException("Result key is empty?");
        }
        if (property.contains(".")) {
            String[] arr = property.split("\\.");
            String clzName = arr[0];
            String p = arr[1];
            Parsed parsed = Parser.get((String)clzName);
            BeanElement element = parsed.getElement(p);
            if (mapper.contains("`")) {
                mapper = mapper.replace("`", "");
            }
            if (element == null) {
                return rs.getObject(mapper);
            }
            return this.getObject(mapper, rs, element);
        }
        if (mapper.contains("`")) {
            mapper = mapper.replace("`", "");
        }
        return rs.getObject(mapper);
    }

    @Override
    public <T> void initObj(T obj, ResultSet rs, BeanElement tempEle, List<BeanElement> eles) throws IOException, SQLException, InvocationTargetException, IllegalAccessException {
        for (BeanElement ele : eles) {
            Method method = ele.setMethod;
            String mapper = ele.getMapper();
            if (mapper.contains("`")) {
                mapper = mapper.replace("`", "");
            }
            Object value = this.getObject(mapper, rs, ele);
            method.invoke(obj, value);
        }
    }

    @Override
    public void setJSON(int i, String str, PreparedStatement pstmt) throws SQLException, IOException {
        pstmt.setString(i, str);
    }

    @Override
    public void setObject(int i, Object obj, PreparedStatement pstm) throws SQLException {
        pstm.setObject(i, obj);
    }

    @Override
    public Object filterValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            value = str.replace("<", "&lt").replace(">", "&gt");
        }
        return value;
    }

    @Override
    public String filterResultKey(String mapper, Criteria.ResultMapped criteria) {
        return mapper;
    }
}

