/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.CriteriaCondition;
import x7.core.bean.MinMax;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.Predicate;
import x7.core.bean.Reduce;
import x7.core.util.BeanUtil;
import x7.core.util.BeanUtilX;
import x7.core.util.StringUtil;
import x7.core.web.Direction;
import x7.repository.CriteriaParser;
import x7.repository.mapper.Mapper;

public class SqlCriteriaParser
implements CriteriaParser {
    @Autowired
    private Mapper.Dialect dialect;

    @Override
    public void setDialect(Mapper.Dialect dialect) {
        this.dialect = dialect;
    }

    private Criteria.MapMapper getMapMapper(Criteria criteria) {
        Criteria.ResultMapped resultMapped = (Criteria.ResultMapped)criteria;
        Criteria.MapMapper mapMapper = resultMapped.getMapMapper();
        return mapMapper;
    }

    private void mapping(String script, Criteria criteria, StringBuilder sb) {
        String[] keyArr = script.split(" ");
        int length = keyArr.length;
        for (int i = 0; i < length; ++i) {
            String origin = keyArr[i].trim();
            String target = this.mapping(origin, criteria);
            sb.append(target).append(" ");
        }
    }

    private String mapping(String key, Criteria criteria) {
        Parsed parsed;
        if (key.contains(".")) {
            String[] arr = key.split("\\.");
            String clzName = arr[0];
            String property = arr[1];
            Parsed parsed2 = Parser.get((String)clzName);
            if (parsed2 == null) {
                throw new RuntimeException("Entity Bean Not Exist: " + BeanUtil.getByFirstUpper((String)key));
            }
            String value = parsed2.getTableName() + "." + parsed2.getMapper(property);
            return value;
        }
        if (criteria instanceof Criteria.ResultMapped && (parsed = Parser.get((String)key)) != null) {
            return parsed.getTableName();
        }
        Class clz = criteria.getClz();
        Parsed parsed3 = Parser.get((Class)clz);
        if (key.equals(BeanUtilX.getByFirstLower((String)clz.getSimpleName()))) {
            return parsed3.getTableName();
        }
        String value = parsed3.getMapper(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    @Override
    public String parseCondition(CriteriaCondition criteriaCondition) {
        StringBuilder sb = new StringBuilder();
        List xList = criteriaCondition.getListX();
        this.x(sb, xList, criteriaCondition, true);
        return sb.toString();
    }

    @Override
    public String[] parse(Criteria criteria) {
        StringBuilder sb = new StringBuilder();
        this.env(criteria);
        this.resultKey(criteria);
        this.select(sb, criteria);
        this.sourceScript(sb, criteria);
        this.x(sb, criteria);
        this.groupBy(sb, criteria);
        this.sort(sb, criteria);
        return this.sqlArr(sb, criteria);
    }

    private String[] sqlArr(StringBuilder sb, Criteria criteria) {
        String[] sqlArr = new String[2];
        if (!criteria.isScroll()) {
            StringBuilder countSb = new StringBuilder();
            countSb.append("SELECT").append(" ").append(criteria.getCountDistinct()).append(" ").append((CharSequence)sb);
            sqlArr[0] = countSb.toString();
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT").append(" ").append(criteria.resultAllScript()).append(" ").append((CharSequence)sb);
        sqlArr[1] = sqlSb.toString();
        System.out.println(sqlArr[1]);
        return sqlArr;
    }

    private void env(Criteria criteria) {
        Criteria.ResultMapped resultMapped;
        Criteria.MapMapper mapMapper;
        if (criteria instanceof Criteria.ResultMapped && Objects.isNull(mapMapper = (resultMapped = (Criteria.ResultMapped)criteria).getMapMapper())) {
            mapMapper = new Criteria.MapMapper();
            resultMapped.setMapMapper(mapMapper);
        }
    }

    private void resultKey(Criteria criteria) {
        String cs;
        List reduceList;
        String value;
        if (!(criteria instanceof Criteria.ResultMapped)) {
            return;
        }
        boolean flag = false;
        Criteria.ResultMapped resultMapped = (Criteria.ResultMapped)criteria;
        StringBuilder column = new StringBuilder();
        Criteria.MapMapper mapMapper = resultMapped.getMapMapper();
        if (Objects.nonNull(resultMapped.getDistinct())) {
            if (!flag) {
                resultMapped.getResultKeyList().clear();
            }
            column.append("DISTINCT");
            List list = resultMapped.getDistinct().getList();
            int size = list.size();
            int i = 0;
            for (String resultKey : list) {
                value = this.mapping(resultKey, criteria);
                column.append(" ").append(value);
                resultMapped.getResultKeyList().add(resultKey);
                mapMapper.put(resultKey, value);
                if (++i >= size) continue;
                column.append(",");
            }
            criteria.setCountDistinct("COUNT(" + column.toString() + ") count");
            flag = true;
        }
        if (!(reduceList = resultMapped.getReduceList()).isEmpty()) {
            if (!flag) {
                resultMapped.getResultKeyList().clear();
            }
            for (Reduce reduce : reduceList) {
                if (flag) {
                    column.append(",");
                }
                String alianProperty = reduce.getProperty() + "_" + reduce.getType().toString().toLowerCase();
                String alianName = alianProperty.replace(".", "_");
                value = this.mapping(reduce.getProperty(), criteria);
                column.append(" ").append(reduce.getType()).append("(").append(value).append(")").append(" ").append(alianName);
                mapMapper.put(alianProperty, alianName);
                resultMapped.getResultKeyList().add(alianProperty);
                flag = true;
            }
        }
        if (StringUtil.isNullOrEmpty((String)(cs = column.toString()))) {
            List resultList = resultMapped.getResultKeyList();
            StringBuilder sb = new StringBuilder();
            if (resultList.isEmpty()) {
                throw new RuntimeException("Suggest API: find(Criteria criteria)");
            }
            int size = resultList.size();
            for (int i = 0; i < size; ++i) {
                String key = (String)resultList.get(i);
                String mapper = this.mapping(key, criteria);
                mapMapper.put(key, mapper);
                mapper = this.dialect.filterResultKey(mapper, resultMapped);
                sb.append(" ").append(mapper);
                if (i >= size - 1) continue;
                sb.append(",");
            }
            criteria.setCustomedResultKey(sb.toString());
        } else {
            criteria.setCustomedResultKey(column.toString());
        }
    }

    private void select(StringBuilder sb, Criteria criteria) {
    }

    private void groupBy(StringBuilder sb, Criteria criteria) {
        if (criteria instanceof Criteria.ResultMapped) {
            Criteria.ResultMapped rm = (Criteria.ResultMapped)criteria;
            String groupByS = rm.getGroupBy();
            if (StringUtil.isNullOrEmpty((String)groupByS)) {
                return;
            }
            sb.append(Conjunction.GROUP_BY.sql());
            String[] arr = groupByS.split(",");
            int i = 0;
            int l = arr.length;
            for (String groupBy : arr) {
                if (!StringUtil.isNotNull((String)(groupBy = groupBy.trim()))) continue;
                String mapper = this.mapping(groupBy, criteria);
                sb.append(mapper);
                if (++i >= l) continue;
                sb.append(",");
            }
        }
    }

    private void sourceScript(StringBuilder sb, Criteria criteria) {
        String script = criteria.sourceScript().trim();
        if (script.startsWith("FROM") || script.startsWith("FROM".toLowerCase())) {
            script = script.replaceFirst("FROM", "");
        }
        sb.append(" ").append("FROM").append(" ");
        this.mapping(script, criteria, sb);
    }

    private void sort(StringBuilder sb, Criteria criteria) {
        if (criteria.isFixedSort()) {
            return;
        }
        List orderByList = criteria.getOrderByList();
        if (!orderByList.isEmpty()) {
            sb.append(Conjunction.ORDER_BY.sql());
            int size = orderByList.size();
            int i = 0;
            for (String ob : orderByList) {
                String mapper = this.mapping(ob, criteria);
                sb.append(mapper).append(" ");
                if (++i >= size) continue;
                sb.append(",").append(" ");
            }
            Direction direction = criteria.getDirection();
            if (direction == null) {
                sb.append(Direction.DESC);
            } else {
                sb.append(direction);
            }
        }
    }

    private void x(StringBuilder sb, List<Criteria.X> xList, CriteriaCondition criteria, boolean isWhere) {
        for (Criteria.X x : xList) {
            Object v = x.getValue();
            if (Objects.isNull(v)) continue;
            if (x.getPredicate() == Predicate.X) {
                this.appendConjunction(sb, x, criteria, isWhere);
                sb.append(x.getValue());
                continue;
            }
            if (Objects.nonNull(x.getConjunction())) {
                List subList = x.getSubList();
                if (x.getSubList() != null) {
                    StringBuilder xSb = new StringBuilder();
                    this.x(xSb, subList, criteria, false);
                    String script = xSb.toString();
                    if (StringUtil.isNotNull((String)script)) {
                        String and = Conjunction.AND.sql();
                        String or = Conjunction.OR.sql();
                        if (script.startsWith(and)) {
                            script = script.replaceFirst(and, "");
                        } else if (script.startsWith(or)) {
                            script = script.replaceFirst(or, "");
                        }
                        x.setScript(Predicate.SUB_BEGIN.sql() + script + Predicate.SUB_END.sql());
                    }
                }
            }
            if (Predicate.SUB_BEGIN == x.getPredicate() || Predicate.SUB_END == x.getPredicate()) continue;
            if (StringUtil.isNotNull((String)x.getKey()) && x.getKey().equals(Predicate.SUB.sql())) {
                if (!Objects.nonNull(x.getScript())) continue;
                this.appendConjunction(sb, x, criteria, isWhere);
                sb.append(x.getScript());
                continue;
            }
            this.x(x, criteria, isWhere);
            if (!Objects.nonNull(x.getScript())) continue;
            sb.append(x.getScript());
        }
    }

    private void x(StringBuilder sb, Criteria criteria) {
        List xList = criteria.getListX();
        StringBuilder xsb = new StringBuilder();
        this.x(xsb, xList, (CriteriaCondition)criteria, true);
        String script = xsb.toString();
        this.mapping(script, criteria, sb);
    }

    private void appendConjunction(StringBuilder sb, Criteria.X x, CriteriaCondition criteriaBuilder, boolean isWhere) {
        if (Objects.isNull(x.getConjunction())) {
            return;
        }
        if (criteriaBuilder instanceof Criteria) {
            Criteria criteria = (Criteria)criteriaBuilder;
            if (isWhere && criteria.isWhere) {
                criteria.isWhere = false;
                sb.append(Conjunction.WHERE.sql());
            } else {
                sb.append(x.getConjunction().sql());
            }
        } else {
            sb.append(x.getConjunction().sql());
        }
    }

    private void x(Criteria.X x, CriteriaCondition criteria, boolean isWhere) {
        StringBuilder sb = new StringBuilder();
        Predicate p = x.getPredicate();
        Object v = x.getValue();
        if (p == Predicate.IN || p == Predicate.NOT_IN) {
            this.appendConjunction(sb, x, criteria, isWhere);
            sb.append(x.getKey()).append(p.sql());
            List inList = (List)v;
            this.in(sb, inList);
        } else if (p == Predicate.BETWEEN) {
            this.appendConjunction(sb, x, criteria, isWhere);
            sb.append(x.getKey()).append(p.sql());
            this.between(sb);
            MinMax minMax = (MinMax)v;
            List valueList = criteria.getValueList();
            valueList.add(minMax.getMin());
            valueList.add(minMax.getMax());
        } else if (p == Predicate.IS_NOT_NULL || p == Predicate.IS_NULL) {
            this.appendConjunction(sb, x, criteria, isWhere);
            sb.append(v).append(p.sql());
        } else {
            if (StringUtil.isNullOrEmpty((String)x.getKey())) {
                return;
            }
            this.appendConjunction(sb, x, criteria, isWhere);
            Class<?> clz = v.getClass();
            sb.append(x.getKey()).append(x.getPredicate().sql());
            if (clz == String.class) {
                String str = v.toString();
                if (str.startsWith("#") && str.endsWith("#")) {
                    str = str.replace("#", "");
                    sb.append(str);
                    return;
                }
                sb.append("?");
            } else {
                sb.append("?");
            }
            if (clz.getSuperclass().isEnum() || clz.isEnum()) {
                criteria.getValueList().add(v.toString());
            } else {
                criteria.getValueList().add(v);
            }
        }
        x.setScript(sb.toString());
    }

    private void between(StringBuilder sb) {
        sb.append("?").append(Conjunction.AND.sql()).append("?");
    }

    private void in(StringBuilder sb, List<Object> inList) {
        if (inList == null || inList.isEmpty()) {
            return;
        }
        Object v = inList.get(0);
        Class<?> vType = v.getClass();
        boolean isNumber = vType == Long.TYPE || vType == Integer.TYPE || vType == Long.class || vType == Integer.class;
        sb.append("(").append(" ");
        int length = inList.size();
        if (isNumber) {
            for (int j = 0; j < length; ++j) {
                Object id = inList.get(j);
                if (id == null) continue;
                sb.append(id);
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else {
            for (int j = 0; j < length; ++j) {
                Object id = inList.get(j);
                if (id == null || StringUtil.isNullOrEmpty((String)id.toString())) continue;
                sb.append("'").append(id).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" ").append(")");
    }
}

