/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataSourceHolder {
    public static final String WRITEABLE_DEFAULT = "dataSource";
    public static final String READABLE_DEFAULT = "readableDataSource";
    private static DataSource dataSource;
    private static DataSource readableDataSource;
    private static final Map<String, DataSource> map;

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void setDataSource(DataSource dataSource) {
        DataSourceHolder.dataSource = dataSource;
        if (dataSource != null) {
            DataSourceHolder.put(WRITEABLE_DEFAULT, dataSource);
        }
    }

    public static DataSource getReadableDataSource() {
        return readableDataSource;
    }

    public static void setReadableDataSource(DataSource readableDatasource) {
        readableDataSource = readableDatasource;
        if (readableDatasource != null) {
            DataSourceHolder.put(READABLE_DEFAULT, readableDatasource);
        }
    }

    public static void put(String key, DataSource dataSource) {
        map.put(key, dataSource);
    }

    public static DataSource get(String key) {
        return map.get(key);
    }

    static {
        map = new ConcurrentHashMap<String, DataSource>();
    }
}

