/*
 * Decompiled with CFR 0.152.
 */
package x7.distributed;

import org.apache.log4j.Logger;
import x7.repository.redis.JedisConnector_Persistence;

public class DistributionLock {
    private static Logger logger = Logger.getLogger(DistributionLock.class);

    private static void lock(String key) {
        boolean locked = JedisConnector_Persistence.getInstance().lock(key);
        if (!locked) {
            logger.info((Object)("Get distributed lock failed, lockKey: " + key));
            throw new RuntimeException("service busy");
        }
        System.out.println("Get distribution lock");
    }

    private static void unLock(String key) {
        JedisConnector_Persistence.getInstance().unLock(key);
        System.out.println("Release distribution lock");
    }

    private static void unLockAsync(String key) {
        System.out.println("Release distribution lock");
    }

    public static Lock by(String key) {
        Lock ml = new Lock();
        ml.setKey(key);
        return ml;
    }

    public static interface Task<T> {
        public T run(Object var1);
    }

    public static class Lock {
        private String key;

        private void setKey(String key) {
            this.key = key;
        }

        public <T> T lock(Task<T> obj) {
            DistributionLock.lock(this.key);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this.key);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLock(this.key);
            }
            return o;
        }

        public <T> T lockAsync(Task<T> obj) {
            DistributionLock.lock(this.key);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this.key);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLockAsync(this.key);
            }
            return o;
        }
    }
}

