/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.sharding;

import x7.core.config.Configs;
import x7.core.util.VerifyUtil;

public enum ShardingPolicy {
    MD5{

        @Override
        public String getKey(long key) {
            int num = Configs.getIntValue((String)"x7.db.sharding.num");
            int to = 1;
            if (num == 256) {
                to = 2;
            }
            String md5Str = VerifyUtil.toMD5((String)String.valueOf(key));
            return md5Str.substring(0, to);
        }

        @Override
        public String getKey(String key) {
            int num = Configs.getIntValue((String)"x7.db.sharding.num");
            int to = 1;
            if (num == 256) {
                to = 2;
            }
            String md5Str = VerifyUtil.toMD5((String)key);
            return md5Str.substring(0, to);
        }

        @Override
        public String[] getSuffixArr() {
            String[] arr16 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
            int num = Configs.getIntValue((String)"x7.db.sharding.num");
            if (num == 256) {
                int n = 0;
                String[] arr256 = new String[256];
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        arr256[n++] = arr16[i] + arr16[j];
                    }
                }
                return arr256;
            }
            return arr16;
        }
    }
    ,
    HASH{

        @Override
        public String getKey(long key) {
            int num = Configs.getIntValue((String)"x7.db.sharding.num");
            return String.valueOf(key % (long)num);
        }

        @Override
        public String getKey(String key) {
            int hash = key.hashCode();
            return this.getKey(hash);
        }

        @Override
        public String[] getSuffixArr() {
            int num = Configs.getIntValue((String)"x7.db.sharding.num");
            String[] arr = new String[num];
            for (int i = 0; i < num; ++i) {
                arr[i] = String.valueOf(i);
            }
            return arr;
        }
    };


    public abstract String getKey(long var1);

    public abstract String getKey(String var1);

    public abstract String[] getSuffixArr();

    public static ShardingPolicy get(String key) {
        if (key == null || key.equals("")) {
            return MD5;
        }
        for (ShardingPolicy value : ShardingPolicy.values()) {
            if (!value.toString().equals(key)) continue;
            return value;
        }
        throw new RuntimeException("CONFIG EXCEPTION, SHARDING NO POLICY");
    }
}

