/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import x7.core.config.Configs;
import x7.core.repository.CacheException;
import x7.core.repository.CacheResolver;
import x7.core.util.JsonX;
import x7.core.util.VerifyUtil;
import x7.core.web.Pagination;
import x7.repository.exception.PersistenceException;
import x7.repository.redis.JedisConnector_Cache;
import x7.repository.redis.ObjectUtil;
import x7.repository.redis.PersistenceUtil;

public class LevelTwoCacheResolver
implements CacheResolver {
    public static final String NANO_SECOND = ".N_S";
    private static LevelTwoCacheResolver instance = null;

    public static LevelTwoCacheResolver getInstance() {
        if (instance == null) {
            instance = new LevelTwoCacheResolver();
        }
        return instance;
    }

    public String markForRefresh(Class clz) {
        String key = this.getNSKey(clz);
        String time = String.valueOf(System.nanoTime());
        boolean flag = JedisConnector_Cache.getInstance().set(key.getBytes(), time.getBytes());
        if (!flag) {
            throw new CacheException("markForRefresh failed");
        }
        return time;
    }

    public void remove(Class clz, String key) {
        key = this.getSimpleKey(clz, key);
        boolean flag = JedisConnector_Cache.getInstance().delete(key.getBytes());
        if (!flag) {
            throw new CacheException("remove failed");
        }
    }

    public void remove(Class clz) {
        String key = this.getSimpleKey(clz);
        Set<String> keySet = JedisConnector_Cache.getInstance().keys(key);
        for (String k : keySet) {
            boolean flag = JedisConnector_Cache.getInstance().delete(k.getBytes());
            if (flag) continue;
            throw new CacheException("remove failed");
        }
    }

    private String getNSKey(Class clz) {
        return clz.getName() + NANO_SECOND;
    }

    private String getNS(String nsKey) {
        return JedisConnector_Cache.getInstance().get(nsKey);
    }

    private List<byte[]> getKeyList(Class clz, List<String> conditionList) {
        if (conditionList == null || conditionList.isEmpty()) {
            return null;
        }
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        for (String condition : conditionList) {
            String key = this.getSimpleKey(clz, condition);
            keyList.add(key.getBytes());
        }
        if (keyList.isEmpty()) {
            return null;
        }
        ArrayList<byte[]> arrList = new ArrayList<byte[]>();
        boolean i = false;
        for (byte[] keyB : keyList) {
            arrList.add(keyB);
        }
        return arrList;
    }

    private String getSimpleKey(Class clz, String condition) {
        return "{" + clz.getName() + "}." + condition;
    }

    private String getSimpleKey(Class clz) {
        return "{" + clz.getName() + "}.*";
    }

    private String getKey(Class clz, Object conditionObj) {
        String condition = JsonX.toJson((Object)conditionObj);
        long startTime = System.currentTimeMillis();
        String key = VerifyUtil.toMD5((String)(this.getPrefix(clz) + condition));
        long endTime = System.currentTimeMillis();
        System.out.println("time_getKey = " + (endTime - startTime));
        return key;
    }

    private String getPrefix(Class clz) {
        String key = this.getNSKey(clz);
        byte[] nsArr = JedisConnector_Cache.getInstance().get(key.getBytes());
        if (nsArr == null) {
            String str = this.markForRefresh(clz);
            return clz.getName() + str;
        }
        return clz.getName() + new String(nsArr);
    }

    public void set(Class clz, String key, Object obj) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        JedisConnector_Cache.getInstance().set(key.getBytes(), PersistenceUtil.toBytes(obj), validSecond);
    }

    private int getValidSecondAdjusted() {
        return Configs.getIntValue((String)"x7.cache.second") * 120;
    }

    public void setResultKeyList(Class clz, Object condition, List<String> keyList) {
        String key = this.getKey(clz, condition);
        int validSecond = Configs.getIntValue((String)"x7.cache.second");
        try {
            JedisConnector_Cache.getInstance().set(key.getBytes(), ObjectUtil.toBytes(keyList), validSecond);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public <T> void setResultKeyListPaginated(Class<T> clz, Object condition, Pagination<T> pagination) {
        int validSecond = Configs.getIntValue((String)"x7.cache.second");
        this.setResultKeyListPaginated(clz, condition, pagination, validSecond);
    }

    public <T> void setResultKeyListPaginated(Class<T> clz, Object condition, Pagination<T> pagination, int second) {
        String key = this.getKey(clz, condition);
        try {
            JedisConnector_Cache.getInstance().set(key.getBytes(), ObjectUtil.toBytes(pagination), second);
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    public List<String> getResultKeyList(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        System.out.println("get key: " + key);
        long startTime = System.currentTimeMillis();
        byte[] bytes = JedisConnector_Cache.getInstance().get(key.getBytes());
        long endTime = System.currentTimeMillis();
        System.out.println("time_getResultKeyList = " + (endTime - startTime));
        if (bytes == null) {
            return new ArrayList<String>();
        }
        return ObjectUtil.toList(bytes, String.class);
    }

    public Pagination<String> getResultKeyListPaginated(Class clz, Object condition) {
        String key = this.getKey(clz, condition);
        System.out.println("get key: " + key);
        byte[] bytes = JedisConnector_Cache.getInstance().get(key.getBytes());
        if (bytes == null) {
            return null;
        }
        return ObjectUtil.toPagination(bytes, String.class);
    }

    public <T> List<T> list(Class<T> clz, List<String> keyList) {
        List<byte[]> keyArr = this.getKeyList(clz, keyList);
        List<byte[]> bytesList = JedisConnector_Cache.getInstance().mget(keyArr);
        if (bytesList == null) {
            return new ArrayList();
        }
        ArrayList<T> objList = new ArrayList<T>();
        for (byte[] bytes : bytesList) {
            T t;
            if (bytes == null || (t = PersistenceUtil.toObject(clz, bytes)) == null) continue;
            objList.add(t);
        }
        return objList;
    }

    public <T> T get(Class<T> clz, String key) {
        key = this.getSimpleKey(clz, key);
        byte[] bytes = JedisConnector_Cache.getInstance().get(key.getBytes());
        if (bytes == null) {
            return null;
        }
        T obj = PersistenceUtil.toObject(clz, bytes);
        return obj;
    }

    public void setMapList(Class clz, String key, List<Map<String, Object>> mapList) {
        key = this.getSimpleKey(clz, key);
        int validSecond = this.getValidSecondAdjusted();
        JedisConnector_Cache.getInstance().set(key.getBytes(), PersistenceUtil.toBytes(mapList), validSecond);
    }

    public List<Map<String, Object>> getMapList(Class clz, String key) {
        key = this.getSimpleKey(clz, key);
        byte[] bytes = JedisConnector_Cache.getInstance().get(key.getBytes());
        if (bytes == null) {
            return null;
        }
        List<Map<String, Object>> mapList = PersistenceUtil.toMapList(bytes);
        return mapList;
    }
}

