/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.redis;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import x7.core.bean.SpringHelper;

public class JedisConnector_Persistence {
    private RedisTemplate redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private static JedisConnector_Persistence instance;

    public static JedisConnector_Persistence getInstance() {
        if (instance == null) {
            instance = new JedisConnector_Persistence();
        }
        return instance;
    }

    private void init() {
        this.redisTemplate = (RedisTemplate)SpringHelper.getObject((String)"redisTemplate");
        this.stringRedisTemplate = (StringRedisTemplate)SpringHelper.getObject((String)"stringRedisTemplate");
    }

    private JedisConnector_Persistence() {
        this.init();
    }

    public boolean set(String key, String value) {
        if (key == null || key.equals("")) {
            return false;
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    public boolean set(byte[] key, byte[] value, int validSeconds) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, (long)validSeconds);
        return true;
    }

    public void set(String key, String value, int seconds) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, (long)seconds);
    }

    public void set(byte[] key, byte[] value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public String get(String key) {
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (str == null) {
            return str;
        }
        return str.trim();
    }

    public List<byte[]> mget(List<byte[]> keyList) {
        if (keyList == null || keyList.isEmpty()) {
            return null;
        }
        List byteList = this.redisTemplate.opsForValue().multiGet(keyList);
        return byteList;
    }

    public byte[] get(byte[] key) {
        Object obj = this.redisTemplate.opsForValue().get((Object)key);
        return (byte[])obj;
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public void delete(byte[] key) {
        this.redisTemplate.delete((Object)key);
    }

    public void hset(String mapName, String key, String value) {
        this.stringRedisTemplate.opsForHash().put((Object)mapName, (Object)key, (Object)value);
    }

    public String hget(String mapName, String key) {
        Object obj = this.stringRedisTemplate.opsForHash().get((Object)mapName, (Object)key);
        if (obj == null) {
            return null;
        }
        return obj.toString().trim();
    }

    public long hincrBy(String mapName, String key, long increment) {
        return this.stringRedisTemplate.opsForHash().increment((Object)mapName, (Object)key, increment);
    }

    public boolean lock(String key) {
        String value = "LOCK";
        boolean isLock = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"LOCK");
        if (isLock) {
            this.stringRedisTemplate.expire((Object)key, 5L, TimeUnit.SECONDS);
        }
        return isLock;
    }

    public void unLock(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }
}

