/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.redis;

import java.util.List;
import java.util.Set;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import x7.core.bean.SpringHelper;

public class JedisConnector_Cache {
    private RedisTemplate redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private static JedisConnector_Cache instance;

    public static JedisConnector_Cache getInstance() {
        if (instance == null) {
            instance = new JedisConnector_Cache();
        }
        return instance;
    }

    private void init() {
        this.redisTemplate = (RedisTemplate)SpringHelper.getObject((String)"redisTemplate");
        this.stringRedisTemplate = (StringRedisTemplate)SpringHelper.getObject((String)"stringRedisTemplate");
    }

    private JedisConnector_Cache() {
        this.init();
    }

    public boolean set(String key, String value) {
        if (key == null || key.equals("")) {
            return false;
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    public boolean set(byte[] key, byte[] value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    public boolean set(byte[] key, byte[] value, int validSeconds) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, (long)validSeconds);
        return true;
    }

    public String get(String key) {
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (str == null) {
            return str;
        }
        return str.trim();
    }

    public List<byte[]> mget(List<byte[]> keyList) {
        if (keyList == null || keyList.isEmpty()) {
            return null;
        }
        List byteList = this.redisTemplate.opsForValue().multiGet(keyList);
        return byteList;
    }

    public byte[] get(byte[] key) {
        Object obj = this.redisTemplate.opsForValue().get((Object)key);
        return (byte[])obj;
    }

    public boolean delete(byte[] key) {
        this.redisTemplate.delete((Object)key);
        return true;
    }

    public Set<String> keys(String pattern) {
        Set set = this.stringRedisTemplate.keys((Object)pattern);
        return set;
    }
}

