/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.pool;

import com.zaxxer.hikari.HikariDataSource;
import x7.core.config.Configs;
import x7.core.util.StringUtil;

public class HikariPoolUtil {
    public static HikariDataSource create(boolean isWriteable) {
        String address = Configs.getString((String)"x7.db.address.r");
        if (isWriteable) {
            address = Configs.getString((String)"x7.db.address.w");
        }
        if (StringUtil.isNullOrEmpty((String)address)) {
            return null;
        }
        int num = Configs.getIntValue((String)"x7.db.read");
        if (!isWriteable && num < 1) {
            return null;
        }
        HikariDataSource dataSource = new HikariDataSource();
        String url = Configs.getString((String)"x7.db.url");
        url = url.replace("${address}", address).replace("${name}", Configs.getString((String)"x7.db.name"));
        System.out.println("\n_________x7.db.url: " + url);
        dataSource.setReadOnly(!isWriteable);
        dataSource.setJdbcUrl(url);
        dataSource.setUsername(Configs.getString((String)"x7.db.username"));
        dataSource.setPassword(Configs.getString((String)"x7.db.password"));
        dataSource.setConnectionTimeout(300000L);
        dataSource.setIdleTimeout(600000L);
        dataSource.setMaxLifetime(1800000L);
        dataSource.setDriverClassName(Configs.getString((String)"x7.db.driver"));
        dataSource.setMaximumPoolSize(Configs.getIntValue((String)"x7.db.max"));
        return dataSource;
    }
}

