/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.util.List;
import x7.core.bean.IQuantity;
import x7.repository.SqlRepository;
import x7.repository.redis.JedisConnector_Persistence;

public class QuantityIncrement {
    private static QuantityIncrement instance;

    public static QuantityIncrement getInstance() {
        if (instance == null) {
            instance = new QuantityIncrement();
        }
        return instance;
    }

    private QuantityIncrement() {
    }

    public int increaseBySingleThreadModel(IQuantity obj, int offset) {
        if (offset < 1) {
            throw new RuntimeException("increasing quantity must > 0");
        }
        String mapKey = obj.getClass().getName();
        int quantity = (int)JedisConnector_Persistence.getInstance().hincrBy(mapKey, obj.getKey(), offset);
        if (quantity <= offset) {
            obj.setQuantity(0);
            List list = SqlRepository.getInstance().list(obj);
            if (!list.isEmpty()) {
                IQuantity q = (IQuantity)list.get(0);
                quantity = q.getQuantity() + offset;
                JedisConnector_Persistence.getInstance().hset(mapKey, obj.getKey(), String.valueOf(quantity));
            }
        }
        obj.setQuantity(quantity);
        return quantity;
    }
}

