/*
 * Decompiled with CFR 0.152.
 */
package x7.repository;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import x7.core.async.CasualWorker;
import x7.core.async.IAsyncTask;
import x7.core.bean.Conjunction;
import x7.core.bean.Criteria;
import x7.core.bean.IQuantity;
import x7.core.bean.Parsed;
import x7.core.bean.Parser;
import x7.core.bean.Predicate;
import x7.core.bean.condition.InCondition;
import x7.core.bean.condition.ReduceCondition;
import x7.core.bean.condition.RefreshCondition;
import x7.core.util.StringUtil;
import x7.core.web.Direction;
import x7.core.web.Pagination;
import x7.repository.DbType;
import x7.repository.IdGenerator;
import x7.repository.ManuRepository;
import x7.repository.SqlRepository;
import x7.repository.api.X7Repository;
import x7.repository.exception.PersistenceException;
import x7.repository.mapper.MapperFactory;
import x7.repository.redis.JedisConnector_Persistence;

public abstract class BaseRepository<T>
implements X7Repository<T> {
    private static final Logger logger = Logger.getLogger(BaseRepository.class);
    public static final String ID_MAP_KEY = "ID_MAP_KEY";
    public Map<String, String> map = new HashMap<String, String>();
    private Class<T> clz;

    protected Class<T> getClz() {
        return this.clz;
    }

    public BaseRepository() {
        this.parse();
    }

    private void parse() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.clz = (Class)params[0];
        logger.info((Object)("BaseRepository<T>, T: " + this.clz.getName()));
        HealthChecker.repositoryList.add(this);
    }

    protected Object find(String methodName, Object ... s) {
        return null;
    }

    @Override
    public void set(byte[] key, byte[] value) {
        JedisConnector_Persistence.getInstance().set(key, value);
    }

    @Override
    public byte[] get(byte[] key) {
        return JedisConnector_Persistence.getInstance().get(key);
    }

    @Override
    public void set(String key, String value, int seconds) {
        JedisConnector_Persistence.getInstance().set(key, value, seconds);
    }

    @Override
    public void set(String key, String value) {
        JedisConnector_Persistence.getInstance().set(key, value);
    }

    @Override
    public String get(String key) {
        return JedisConnector_Persistence.getInstance().get(key);
    }

    @Override
    public long createId() {
        final String name = this.clz.getName();
        final long id = JedisConnector_Persistence.getInstance().hincrBy(ID_MAP_KEY, name, 1L);
        if (id == 0L) {
            throw new PersistenceException("UNEXPECTED EXCEPTION WHILE CREATING ID");
        }
        CasualWorker.accept((IAsyncTask)new IAsyncTask(){

            public void execute() throws Exception {
                IdGenerator generator = new IdGenerator();
                generator.setClzName(name);
                generator.setMaxId(id);
                StringBuilder sb = new StringBuilder();
                sb.append("update idGenerator set maxId = ").append(id).append(" where clzName = '").append(name).append("' and ").append(id).append(" > maxId ;");
                try {
                    Parsed parsed = Parser.get(IdGenerator.class);
                    String sql = sb.toString();
                    ManuRepository.execute(generator, sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return id;
    }

    @Override
    public int reduce(IQuantity obj, int reduced) {
        if (reduced < 0) {
            throw new RuntimeException("reduced quantity must > 0");
        }
        String mapKey = obj.getClass().getName();
        int quantity = (int)JedisConnector_Persistence.getInstance().hincrBy(mapKey, obj.getKey(), -reduced);
        obj.setQuantity(quantity);
        return quantity;
    }

    @Override
    public boolean createBatch(List<T> objList) {
        return SqlRepository.getInstance().createBatch(objList);
    }

    @Override
    public long create(T obj) {
        System.out.println("BaesRepository.create: " + obj);
        long id = SqlRepository.getInstance().create(obj);
        return id;
    }

    @Override
    public boolean refresh(T obj) {
        Parsed parsed = Parser.get(this.clz);
        Field keyField = parsed.getKeyField(1);
        if (Objects.isNull(keyField)) {
            throw new RuntimeException("No PrimaryKey, UnSafe Refresh, try to invoke BaseRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
        }
        keyField.setAccessible(true);
        try {
            Object value = keyField.get(obj);
            if (Objects.isNull(value) || value.toString().equals("0")) {
                throw new RuntimeException("UnSafe Refresh, try to invoke BaseRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("refresh safe, get keyOne exception");
        }
        return SqlRepository.getInstance().refresh(obj);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean refresh(RefreshCondition<T> refreshCondition) {
        refreshCondition.setClz(this.clz);
        parsed = Parser.get(this.clz);
        keyField = parsed.getKeyField(1);
        if (Objects.isNull(keyField)) {
            throw new PersistenceException("No PrimaryKey, UnSafe Refresh, try to invoke BaseRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
        }
        obj = refreshCondition.getObj();
        criteriaCondition = refreshCondition.getCondition();
        unSafe = false;
        if (Objects.nonNull(obj)) {
            keyField.setAccessible(true);
            try {
                value = keyField.get(obj);
                if (Objects.isNull(value)) {
                    unSafe = true;
                }
                if (!value.toString().equals("0")) ** GOTO lbl23
                unSafe = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("refresh safe, get keyOne exception");
            }
        } else {
            unSafe = true;
        }
lbl23:
        // 4 sources

        if (unSafe) {
            key = parsed.getKey(1);
            for (Criteria.X x : criteriaCondition.getListX()) {
                if (!key.equals(x.getKey()) || !Objects.nonNull(value = x.getValue()) || value.toString().equals("0")) continue;
                unSafe = false;
            }
        }
        if (unSafe) {
            throw new PersistenceException("UnSafe Refresh, try to invoke BaseRepository.refreshUnSafe(RefreshCondition<T> refreshCondition)");
        }
        return SqlRepository.getInstance().refresh(refreshCondition);
    }

    @Override
    public boolean refreshUnSafe(RefreshCondition<T> refreshCondition) {
        refreshCondition.setClz(this.clz);
        return SqlRepository.getInstance().refresh(refreshCondition);
    }

    @Override
    public void remove(T obj) {
        SqlRepository.getInstance().remove(obj);
    }

    @Override
    public T get(long idOne) {
        return SqlRepository.getInstance().get(this.clz, idOne);
    }

    @Override
    public List<T> list() {
        return SqlRepository.getInstance().list(this.clz);
    }

    @Override
    public List<T> list(T conditionObj) {
        if (conditionObj instanceof Criteria.ResultMapped) {
            throw new RuntimeException("Exception supported, no pagination not to invoke SqlRepository.getInstance().list(criteriaJoinalbe);");
        }
        return SqlRepository.getInstance().list(conditionObj);
    }

    @Override
    public Pagination<Map<String, Object>> find(Criteria.ResultMapped criteria) {
        return SqlRepository.getInstance().find(criteria);
    }

    @Override
    public T getOne(T conditionObj, String orderBy, Direction sc) {
        return SqlRepository.getInstance().getOne(conditionObj, orderBy, sc);
    }

    @Override
    public T getOne(T conditionObj) {
        T t = SqlRepository.getInstance().getOne(conditionObj);
        return t;
    }

    @Override
    public void refreshCache() {
        SqlRepository.getInstance().refreshCache(this.clz);
    }

    @Override
    public Object reduce(ReduceCondition reduceCondition) {
        reduceCondition.setClz(this.clz);
        return SqlRepository.getInstance().reduce(reduceCondition);
    }

    @Override
    public List<T> in(InCondition inCondition) {
        if (inCondition.getInList().isEmpty()) {
            return new ArrayList();
        }
        inCondition.setClz(this.clz);
        return SqlRepository.getInstance().in(inCondition);
    }

    @Override
    public Pagination<T> find(Criteria criteria) {
        return SqlRepository.getInstance().find(criteria);
    }

    public static enum SimpleX {
        AND{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setConjunction(Conjunction.AND);
                return x;
            }
        }
        ,
        OR{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setConjunction(Conjunction.OR);
                return x;
            }
        }
        ,
        NOTIN{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.NOT_IN);
                return x;
            }
        }
        ,
        IN{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.IN);
                return x;
            }
        }
        ,
        LIKE{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.LIKE);
                return x;
            }
        }
        ,
        ISNOTNULL{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.IS_NOT_NULL);
                return x;
            }
        }
        ,
        ISNULL{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.IS_NULL);
                return x;
            }
        }
        ,
        NE{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.NE);
                return x;
            }
        }
        ,
        EQ{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.EQ);
                return x;
            }
        }
        ,
        GTE{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.GTE);
                return x;
            }
        }
        ,
        GT{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.GT);
                return x;
            }
        }
        ,
        LTE{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.LTE);
                return x;
            }
        }
        ,
        LT{

            @Override
            public Criteria.X x() {
                Criteria.X x = new Criteria.X();
                x.setPredicate(Predicate.LT);
                return x;
            }
        };


        public abstract Criteria.X x();
    }

    public static class HealthChecker {
        private static List<BaseRepository> repositoryList = new ArrayList<BaseRepository>();

        protected static void onStarted() {
            Parsed parsed = Parser.get(IdGenerator.class);
            String sql = "CREATE TABLE IF NOT EXISTS `idGenerator` ( `clzName` varchar(120) NOT NULL, `maxId` bigint(13) DEFAULT NULL, PRIMARY KEY (`clzName`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
            try {
                ManuRepository.execute(IdGenerator.class, sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("-------------------------------------------------");
            boolean flag = false;
            for (BaseRepository repository : repositoryList) {
                try {
                    Parsed clzParsed;
                    Field f;
                    Class clz = repository.getClz();
                    String createSql = MapperFactory.tryToCreate(clz);
                    String test = MapperFactory.getSql(clz, "CREATE");
                    if (StringUtil.isNullOrEmpty((String)test)) {
                        System.out.println("FAILED TO START X7-REPOSITORY, check Bean: " + clz);
                        System.exit(1);
                    }
                    if (DbType.value.equals("mysql")) {
                        System.out.println("________ table check: " + clz.getName());
                        System.out.println("________ SQL   check: " + createSql);
                        SqlRepository.getInstance().execute(clz.newInstance(), createSql);
                    }
                    if ((f = (clzParsed = Parser.get(clz)).getKeyField(1)).getType() == String.class) continue;
                    String name = clz.getName();
                    IdGenerator generator = new IdGenerator();
                    generator.setClzName(name);
                    List list = SqlRepository.getInstance().list(generator);
                    if (!list.isEmpty()) continue;
                    System.out.println("________ id init: " + generator.getClzName());
                    generator.setMaxId(0L);
                    SqlRepository.getInstance().create(generator);
                }
                catch (Exception e) {
                    flag |= true;
                }
            }
            logger.info((Object)("X7 Repository " + (flag ? "still " : "") + "started" + (flag ? " OK, wtih some problem" : "")));
        }
    }
}

