/*
 * Decompiled with CFR 0.152.
 */
package x7.repository.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import x7.repository.dao.DataSourceRouter;

public class RcDataSourceUtil {
    private static final Map<String, Connection> connectionMap = new ConcurrentHashMap<String, Connection>();
    private static final Map<String, String> keyMap = new ConcurrentHashMap<String, String>();

    public static Connection getConnection() {
        try {
            return RcDataSourceUtil.getConnection0();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static Connection getConnection0() throws Exception {
        String key = RcDataSourceUtil.getKey();
        DataSource ds = RcDataSourceUtil.getDataSourceReadable();
        Connection conn = null;
        if (key == null) {
            conn = ds.getConnection();
            if (conn == null) {
                try {
                    TimeUnit.MICROSECONDS.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                conn = ds.getConnection();
            }
        } else {
            conn = connectionMap.get(key);
            if (conn == null) {
                conn = ds.getConnection();
                if (conn == null) {
                    try {
                        TimeUnit.MICROSECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    conn = ds.getConnection();
                }
                connectionMap.put(key, conn);
            }
        }
        if (conn == null) {
            System.out.println("_______NO CONNECTION");
            throw new RuntimeException("NO CONNECTION");
        }
        return conn;
    }

    protected static void releaseConnection(Connection conn) {
        String key = RcDataSourceUtil.getKey();
        if (key == null) {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException("RcDataSourceUtil.releaseConnection Exception: " + e.getMessage());
            }
            return;
        }
    }

    public static void closeConnection() {
        String key = RcDataSourceUtil.getKey();
        if (key == null) {
            return;
        }
        Connection conn = connectionMap.remove(key);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String threadId = String.valueOf(Thread.currentThread().getId());
        keyMap.remove(threadId);
    }

    private static String getKey() {
        String threadId = String.valueOf(Thread.currentThread().getId());
        return keyMap.get(threadId);
    }

    private static DataSource getDataSourceReadable() {
        DataSource ds = DataSourceRouter.getDataSourceReadable();
        if (ds == null) {
            ds = DataSourceRouter.getDataSource();
        }
        return ds;
    }

    public static void key() {
        String threadId = String.valueOf(Thread.currentThread().getId());
        String key = "rcTx." + threadId;
        keyMap.put(threadId, key);
    }
}

