/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.lock;

import io.xream.x7.base.exception.DistributionLockException;
import io.xream.x7.base.util.VerifyUtil;
import io.xream.x7.lock.LockProvider;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionLock {
    private static Logger logger = LoggerFactory.getLogger(DistributionLock.class);
    private static int INTERVAL = 1000;
    protected static int TIMEOUT = 10000;
    private static LockProvider lockProvider;

    public static void init(LockProvider lp) {
        lockProvider = lp;
    }

    private static void lock(String key, String value, int interval, int timeout, boolean abortingIfNoLock) {
        if (lockProvider == null) {
            throw new RuntimeException("No implements of LockProvider, like the project x7-repo/x7-redis-integration");
        }
        int i = 1;
        boolean locked = lockProvider.lock(key, value, timeout);
        int retryMax = timeout / interval + 10;
        if (!abortingIfNoLock) {
            while (!locked) {
                try {
                    TimeUnit.MILLISECONDS.sleep(interval);
                    locked = lockProvider.lock(key, value, timeout);
                }
                catch (Exception e) {
                    break;
                }
                if (++i < retryMax) continue;
            }
        }
        if (!locked) {
            logger.info("Get distributed lock failed, lockKey: " + key);
            throw new DistributionLockException();
        }
    }

    private static void unLock(Lock lock) {
        lockProvider.unLock(lock);
    }

    private static void unLockAsync(String key) {
    }

    public static Lock by(String key) {
        Lock ml = new Lock();
        ml.setKey(key + "~LOCK");
        String random = VerifyUtil.toMD5((String)("LOCK" + System.nanoTime()));
        ml.setValue(random);
        return ml;
    }

    public static interface Task<T> {
        public T run(Object var1);
    }

    public static class Lock {
        private String key;
        private String value;

        private Lock() {
        }

        private void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public <T> T lock(Task<T> obj) {
            return this.lock(INTERVAL, TIMEOUT, false, obj);
        }

        public <T> T lock(int intervalMS, int timeoutMS, boolean abortingIfNoLock, Task<T> obj) {
            DistributionLock.lock(this.key, this.value, intervalMS, timeoutMS, abortingIfNoLock);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLock(this);
            }
            return o;
        }

        public <T> T lockAsync(Task<T> obj) {
            DistributionLock.lock(this.key, this.value, INTERVAL, TIMEOUT, false);
            T o = null;
            try {
                o = obj.run(obj);
            }
            catch (Exception e) {
                DistributionLock.unLock(this);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            finally {
                DistributionLock.unLockAsync(this.key);
            }
            return o;
        }
    }
}

